/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView.respawnBlock;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import fi.dy.masa.malilib.config.IConfigBoolean;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.features.infoView.CommonScannerInfoViewer;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.RenderVisitorWorldView;
import me.fallenbreath.tweakermore.impl.features.infoView.respawnBlock.handler.AbstractBlockHandler;
import me.fallenbreath.tweakermore.impl.features.infoView.respawnBlock.handler.BedHandler;
import me.fallenbreath.tweakermore.impl.features.infoView.respawnBlock.handler.RespawnAnchorHandler;
import me.fallenbreath.tweakermore.util.Messenger;
import me.fallenbreath.tweakermore.util.TemporaryBlockReplacer;
import me.fallenbreath.tweakermore.util.damage.DamageCalculator;
import me.fallenbreath.tweakermore.util.damage.DamageUtil;
import me.fallenbreath.tweakermore.util.render.TextRenderer;
import me.fallenbreath.tweakermore.util.render.context.RenderContext;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RespawnBlockExplosionViewer
extends CommonScannerInfoViewer {
    private static final List<BlockHandlerProvider> BLOCK_HANDLER_FACTORIES = ImmutableList.of(BedHandler::new, RespawnAnchorHandler::new);
    private final LongOpenHashSet renderedKeys = new LongOpenHashSet();
    private final Map<Vec3, DamageCache> damageCache = Maps.newHashMap();

    public RespawnBlockExplosionViewer() {
        super((IConfigBoolean)TweakerMoreConfigs.INFO_VIEW_RESPAWN_BLOCK_EXPLOSION, TweakerMoreConfigs.INFO_VIEW_RESPAWN_BLOCK_EXPLOSION_RENDER_STRATEGY, TweakerMoreConfigs.INFO_VIEW_RESPAWN_BLOCK_EXPLOSION_TARGET_STRATEGY);
    }

    @Nullable
    private static ChatFormatting stagedColor(float value, float[] bounds, ChatFormatting[] formattings) {
        if (bounds.length == formattings.length) {
            for (int i = 0; i < bounds.length; ++i) {
                if (!(value <= bounds[i])) continue;
                return formattings[i];
            }
        }
        return null;
    }

    @Override
    public boolean shouldRenderFor(RenderVisitorWorldView world, BlockPos pos) {
        for (BlockHandlerProvider factory : BLOCK_HANDLER_FACTORIES) {
            if (!factory.construct(world, pos, world.getBlockState(pos)).isValid()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean requireBlockEntitySyncing(RenderVisitorWorldView world, BlockPos pos) {
        return false;
    }

    @Override
    protected void render(RenderContext context, RenderVisitorWorldView world, BlockPos pos, boolean isCrossHairPos) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel clientWorld = mc.level;
        if (clientWorld == null || mc.player == null) {
            return;
        }
        Optional<AbstractBlockHandler> optionalBlockHandler = BLOCK_HANDLER_FACTORIES.stream().map(fac -> fac.construct(world, pos, world.getBlockState(pos))).filter(AbstractBlockHandler::isValid).findFirst();
        if (optionalBlockHandler.isEmpty()) {
            return;
        }
        AbstractBlockHandler handler = optionalBlockHandler.get();
        if (!this.renderedKeys.add(handler.getDeduplicationKey().asLong())) {
            return;
        }
        DamageCache cache = this.damageCache.computeIfAbsent(handler.getExplosionCenter(), explosionCenter -> {
            TemporaryBlockReplacer replacer = new TemporaryBlockReplacer((Level)clientWorld);
            handler.addBlocksToRemove(replacer);
            replacer.removeBlocks();
            DamageCalculator calculator = DamageCalculator.explosion(explosionCenter, handler.getExplosionPower(), (LivingEntity)mc.player);
            replacer.restoreBlocks();
            Level bestWorld = world.getBestWorld();
            if (bestWorld instanceof ServerLevel) {
                calculator.setServerWorld((ServerLevel)bestWorld);
            }
            calculator.applyDifficulty(bestWorld.getDifficulty());
            float baseAmount = calculator.getDamageAmount();
            calculator.applyArmorAndResistanceAndEnchantment();
            float appliedAmount = calculator.getDamageAmount();
            calculator.applyAbsorption();
            float remainingHealth = calculator.getEntityHealthAfterDeal();
            return new DamageCache(calculator.getDamageSource(), baseAmount, appliedAmount, remainingHealth);
        });
        ChatFormatting amountFmt = RespawnBlockExplosionViewer.stagedColor(cache.remainingHealth, new float[]{0.0f, mc.player.getMaxHealth() * 0.2f}, new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.GOLD});
        ChatFormatting lineFmt = RespawnBlockExplosionViewer.stagedColor(cache.baseAmount, new float[]{1.0E-6f, DamageUtil.modifyDamageForDifficulty(1.0f, world.getBestWorld().getDifficulty(), cache.damageSource)}, new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.GRAY});
        Function<Float, Component> float2text = hp -> {
            MutableComponent text = Messenger.s(String.format("%.2f", hp));
            if (amountFmt != null) {
                Messenger.formatting(text, amountFmt);
            }
            return text;
        };
        Function<MutableComponent, Component> lineModifier = text -> {
            if (amountFmt == null && lineFmt != null) {
                Messenger.formatting(text, lineFmt);
            }
            return text;
        };
        MutableComponent line1 = Messenger.tr("tweakermore.impl.infoViewRespawnBlockExplosion.damage", float2text.apply(Float.valueOf(cache.appliedAmount)));
        MutableComponent line2 = Messenger.c("-> ", float2text.apply(Float.valueOf(cache.remainingHealth)), "HP");
        double alpha = TweakerMoreConfigs.INFO_VIEW_RESPAWN_BLOCK_EXPLOSION_TEXT_ALPHA.getDoubleValue();
        if (alpha > 0.0) {
            int textAlphaBits = ((int)Math.round(255.0 * alpha) & 0xFF) << 24;
            int bgAlphaBits = ((int)Math.round(31.0 * alpha) & 0xFF) << 24;
            TextRenderer.create().at(handler.getTextPosition()).addLine(lineModifier.apply(line1)).addLine(lineModifier.apply(line2)).color(0xFFFFFF | textAlphaBits, 0 | bgAlphaBits).seeThrough().shadow().render();
        }
    }

    @Override
    public void onInfoViewStart() {
        this.renderedKeys.clear();
    }

    @Override
    public void onClientTick() {
        this.damageCache.clear();
    }

    @FunctionalInterface
    private static interface BlockHandlerProvider {
        public AbstractBlockHandler construct(RenderVisitorWorldView var1, BlockPos var2, BlockState var3);
    }

    private static class DamageCache {
        public final DamageSource damageSource;
        public final float baseAmount;
        public final float appliedAmount;
        public final float remainingHealth;

        public DamageCache(DamageSource damageSource, float baseAmount, float appliedAmount, float remainingHealth) {
            this.damageSource = damageSource;
            this.baseAmount = baseAmount;
            this.appliedAmount = appliedAmount;
            this.remainingHealth = remainingHealth;
        }
    }
}

