/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict;

import com.google.common.collect.Lists;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.LayerRange;
import java.util.List;
import java.util.Optional;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.config.options.listentries.SchematicBlockPlacementRestrictionHintType;
import me.fallenbreath.tweakermore.impl.features.schematicProPlace.ProPlaceUtils;
import me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict.BlockInteractionRestrictor;
import me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict.LooseCaseChecker;
import me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict.RestrictionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;

public class PlacementRestrictor {
    private static final List<Property<?>> FACING_PROPERTIES = Lists.newArrayList((Object[])new Property[]{BlockStateProperties.FACING, BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.FACING_HOPPER, BlockStateProperties.ROTATION_16, BlockStateProperties.HALF, BlockStateProperties.AXIS, BlockStateProperties.HORIZONTAL_AXIS});

    private static void info(boolean condition, String key, Object ... args) {
        if (condition) {
            InfoUtils.printActionbarMessage((String)("tweakermore.impl.schematicBlockPlacementRestriction.info." + key), (Object[])args);
        }
    }

    public static boolean canDoBlockPlacement(Minecraft mc, BlockHitResult hitResult, BlockPlaceContext context) {
        int MARGIN = TweakerMoreConfigs.SCHEMATIC_BLOCK_PLACEMENT_RESTRICTION_MARGIN.getIntegerValue();
        SchematicBlockPlacementRestrictionHintType hintType = (SchematicBlockPlacementRestrictionHintType)TweakerMoreConfigs.SCHEMATIC_BLOCK_PLACEMENT_RESTRICTION_HINT.getOptionListValue();
        BlockPos pos = context.getClickedPos();
        if (!WorldUtils.isPositionWithinRangeOfSchematicRegions((BlockPos)pos, (int)MARGIN)) {
            return true;
        }
        LayerRange layerRange = DataManager.getRenderLayerRange();
        if (!RestrictionUtils.isWithinLayerRange(layerRange, pos, MARGIN)) {
            return true;
        }
        WorldSchematic schematicWorld = SchematicWorldHandler.getSchematicWorld();
        Level realWorld = context.getLevel();
        Player player = context.getPlayer();
        if (schematicWorld != null && player != null && mc.gameMode != null) {
            Optional<BlockState> stateToPlaceOptional;
            BlockPos interactPos = hitResult.getBlockPos();
            BlockState interactWorldState = realWorld.getBlockState(interactPos);
            BlockState interactSchematicState = schematicWorld.getBlockState(interactPos);
            BlockInteractionRestrictor.Result result = BlockInteractionRestrictor.checkInteract(player, interactWorldState, interactSchematicState);
            switch (result.getType()) {
                case GOOD_INTERACTION: {
                    return true;
                }
                case BAD_INTERACTION: {
                    PlacementRestrictor.info(hintType.showNotAllowed, "interaction_not_allowed", result.getMessage());
                    return false;
                }
            }
            BlockState schematicState = schematicWorld.getBlockState(pos);
            Block schematicBlock = schematicState.getBlock();
            ItemStack schematicStack = ProPlaceUtils.getItemForState(schematicState, (Level)schematicWorld, pos);
            ItemStack stackToUse = RestrictionUtils.getPlayerUsingStack(player);
            if (RestrictionUtils.isItemInRestrictorWhitelist(stackToUse)) {
                return true;
            }
            if (!layerRange.isPositionWithinRange(pos)) {
                PlacementRestrictor.info(hintType.showNotPossible, "outside_the_layer", new Object[0]);
                return false;
            }
            if (!LooseCaseChecker.isLooseCheckSpecialCase(schematicState, schematicStack, stackToUse)) {
                if (schematicStack.isEmpty()) {
                    PlacementRestrictor.info(hintType.showNotPossible, schematicState.isAir() ? "is_air" : "no_block", schematicBlock.getName());
                    return false;
                }
                if (stackToUse.getItem() != schematicStack.getItem()) {
                    PlacementRestrictor.info(hintType.showWrongItem, "wrong_item", schematicStack.getItemName());
                    return false;
                }
            }
            if ((stateToPlaceOptional = RestrictionUtils.getStateToPlace(context, stackToUse)).isPresent()) {
                SlabType targetSlabType;
                BlockState stateToPlace = stateToPlaceOptional.get();
                Block blockToPlace = stateToPlace.getBlock();
                if (!PlacementRestrictor.isBlockToPlaceCorrect(schematicState, stateToPlace)) {
                    PlacementRestrictor.info(hintType.showNotAllowed, "wrong_block_type", BuiltInRegistries.BLOCK.getId((Object)schematicBlock));
                    return false;
                }
                if (TweakerMoreConfigs.SCHEMATIC_BLOCK_PLACEMENT_RESTRICTION_CHECK_SLAB.getBooleanValue() && blockToPlace instanceof SlabBlock && schematicBlock instanceof SlabBlock && (targetSlabType = (SlabType)schematicState.getValue((Property)SlabBlock.TYPE)) != SlabType.DOUBLE && stateToPlace.getValue((Property)SlabBlock.TYPE) != targetSlabType) {
                    PlacementRestrictor.info(hintType.showNotAllowed, "wrong_slab", targetSlabType);
                    return false;
                }
                if (TweakerMoreConfigs.SCHEMATIC_BLOCK_PLACEMENT_RESTRICTION_CHECK_FACING.getBooleanValue()) {
                    for (Property<?> property : FACING_PROPERTIES) {
                        if (!stateToPlace.hasProperty(property) || !schematicState.hasProperty(property) || stateToPlace.getValue(property) == schematicState.getValue(property)) continue;
                        PlacementRestrictor.info(hintType.showNotAllowed, "wrong_facing", schematicState.getValue(property));
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static boolean isBlockToPlaceCorrect(BlockState schematicState, BlockState stateToPlace) {
        Block schematicBlock = schematicState.getBlock();
        Block blockToPlace = stateToPlace.getBlock();
        if (LooseCaseChecker.isLooseCheckSpecialCase(schematicState, blockToPlace)) {
            return true;
        }
        if (schematicBlock instanceof FlowerPotBlock && blockToPlace == Blocks.FLOWER_POT) {
            return true;
        }
        if (schematicBlock instanceof CauldronBlock && blockToPlace == Blocks.CAULDRON) {
            return true;
        }
        return blockToPlace == schematicBlock;
    }
}

