/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.spectatorTeleportCommand;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.UUID;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.features.spectatorTeleportCommand.EntitySelectorHack;
import me.fallenbreath.tweakermore.util.Messenger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundTeleportToEntityPacket;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber(modid="tweakermoreforge")
public class SpectatorTeleportCommand {
    @SubscribeEvent
    public static void onCmdRegister(RegisterCommandsEvent event) {
        String prefix = TweakerMoreConfigs.SPECTATOR_TELEPORT_COMMAND_PREFIX.getStringValue();
        CommandDispatcher dispatcher = event.getDispatcher();
        TweakerMoreMod.LOGGER.debug("(spectatorTeleportCommand) Registered client-side command with prefix '{}'", (Object)prefix);
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)prefix).requires(s -> TweakerMoreConfigs.SPECTATOR_TELEPORT_COMMAND.getBooleanValue())).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).executes(context -> SpectatorTeleportCommand.doSpectatorTeleport((CommandSourceStack)context.getSource(), SpectatorTeleportCommand.getEntity((CommandContext<CommandSourceStack>)context, "target"))));
        dispatcher.register(builder);
    }

    public static UUID getEntity(CommandContext<CommandSourceStack> context, String target) throws CommandSyntaxException {
        EntitySelector selector = (EntitySelector)context.getArgument(target, EntitySelector.class);
        return EntitySelectorHack.getSingleEntityUuid(selector, (CommandSourceStack)context.getSource());
    }

    private static int doSpectatorTeleport(CommandSourceStack source, UUID target) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return 0;
        }
        if (!player.isSpectator()) {
            source.sendFailure((Component)Messenger.tr("tweakermore.impl.spectatorTeleportCommand.need_spectator", new Object[0]));
            return 0;
        }
        TweakerMoreMod.LOGGER.info("Performing spectator teleport to entity {}", (Object)target);
        player.connection.send((Packet)new ServerboundTeleportToEntityPacket(target));
        return 1;
    }
}

