/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxTooltipHints;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxTooltipHints.builder.AbstractHintBuilder;
import me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxTooltipHints.builder.EnchantmentHintBuilder;
import me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxTooltipHints.builder.PotionHintBuilder;
import me.fallenbreath.tweakermore.util.InventoryUtils;
import me.fallenbreath.tweakermore.util.Messenger;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ShulkerBoxToolTipEnhancer {
    private static final List<AbstractHintBuilder> HINT_BUILDERS = ImmutableList.of((Object)new EnchantmentHintBuilder(), (Object)new PotionHintBuilder());

    public static void appendContentHints(Item.TooltipContext conComponent, ItemStack itemStack, MutableComponent Component2) {
        HINT_BUILDERS.stream().map(builder -> builder.build(conComponent, itemStack)).filter(Objects::nonNull).forEach(arg_0 -> ((MutableComponent)Component2).append(arg_0));
    }

    public static void applyFillLevelHint(ItemStack skulker, List<Component> tooltip) {
        if (TweakerMoreConfigs.SHULKER_BOX_TOOLTIP_FILL_LEVEL_HINT.getBooleanValue() && !tooltip.isEmpty()) {
            Component prevSpacing;
            List siblings;
            int slotAmount = InventoryUtils.getInventorySlotAmount(skulker);
            if (slotAmount == -1) {
                return;
            }
            NonNullList stackList = fi.dy.masa.malilib.util.InventoryUtils.getStoredItems((ItemStack)skulker, (int)slotAmount);
            if (stackList.isEmpty()) {
                return;
            }
            double sum = 0.0;
            for (ItemStack stack : stackList) {
                sum += 1.0 * (double)stack.getCount() / (double)stack.getMaxStackSize();
            }
            double ratio = sum / (double)slotAmount;
            ChatFormatting color = ratio >= 1.0 ? ChatFormatting.DARK_GREEN : ChatFormatting.GRAY;
            MutableComponent fillLevelComponent = Messenger.s(String.format("%.2f%%", 100.0 * ratio), color);
            Object spacing = " ";
            MutableComponent firstLine = Messenger.c(tooltip.get(0), spacing, fillLevelComponent);
            Font Font2 = Minecraft.getInstance().font;
            ToIntFunction<Component> ComponentLenCalc = text -> Font2.width((FormattedText)text);
            int maxWidth = tooltip.stream().mapToInt(ComponentLenCalc).max().orElse(0);
            do {
                siblings = firstLine.getSiblings();
                spacing = (String)spacing + " ";
                prevSpacing = (Component)siblings.get(1);
                siblings.set(1, Messenger.s(spacing));
            } while (ComponentLenCalc.applyAsInt((Component)firstLine) <= maxWidth);
            siblings.set(1, prevSpacing);
            tooltip.set(0, (Component)firstLine);
        }
    }
}

