/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mc_tweaks.windowSize;

import com.mojang.blaze3d.platform.Window;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import net.minecraft.client.Minecraft;
import org.lwjgl.glfw.GLFW;

public class WindowSizeHelper {
    public static void applyWindowSize() {
        Window window = WindowSizeHelper.getMcWindow();
        if (window == null) {
            return;
        }
        if (window.isFullscreen()) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"tweakermore.impl.windowSize.full_screen_nope", (Object[])new Object[0]);
            return;
        }
        WindowSizeHelper.applyWindowSizeImpl(window);
    }

    public static void onWindowSizeChanged(Window window) {
        if (!TweakerMoreConfigs.WINDOW_SIZE_PINNED.getBooleanValue()) {
            return;
        }
        if (window.isFullscreen()) {
            return;
        }
        int windowWidth = window.getWidth();
        int windowHeight = window.getHeight();
        int configWidth = WindowSizeHelper.getConfigWidth();
        int configHeight = WindowSizeHelper.getConfigHeight();
        if (windowWidth != configWidth || windowHeight != configHeight) {
            TweakerMoreMod.LOGGER.debug("Window size was changed to ({}, {}) and is different to the configured size ({}, {}), resizing", (Object)windowWidth, (Object)windowHeight, (Object)configWidth, (Object)configHeight);
            WindowSizeHelper.applyWindowSizeImpl(window);
        }
    }

    public static void onConfigLoaded() {
        Window window = WindowSizeHelper.getMcWindow();
        if (WindowSizeHelper.canPerformSizeChange(window)) {
            WindowSizeHelper.onWindowSizeChanged(window);
        }
    }

    private static Window getMcWindow() {
        Minecraft mc = Minecraft.getInstance();
        return mc.getWindow();
    }

    private static boolean canPerformSizeChange(Window window) {
        return window != null && !window.isFullscreen();
    }

    private static int getConfigWidth() {
        return Math.max(1, TweakerMoreConfigs.WINDOW_SIZE_WIDTH.getIntegerValue());
    }

    private static int getConfigHeight() {
        return Math.max(1, TweakerMoreConfigs.WINDOW_SIZE_HEIGHT.getIntegerValue());
    }

    private static void applyWindowSizeImpl(Window window) {
        if (window.isFullscreen()) {
            throw new RuntimeException("resize in full screen");
        }
        GLFW.glfwSetWindowSize((long)window.getWindow(), (int)WindowSizeHelper.getConfigWidth(), (int)WindowSizeHelper.getConfigHeight());
    }
}

