/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util.render;

import java.util.Objects;
import me.fallenbreath.tweakermore.util.render.context.RenderContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class RenderUtils {
    private static final Font TEXT_RENDERER = Minecraft.getInstance().font;
    public static final int TEXT_HEIGHT;
    public static final int TEXT_LINE_HEIGHT;
    public static float tickDelta;

    public static int getRenderWidth(String text) {
        return TEXT_RENDERER.width(text);
    }

    public static int getSizeScalingXSign() {
        return 1;
    }

    public static int getRenderWidth(FormattedText text) {
        return TEXT_RENDERER.width(text);
    }

    public static int getRenderWidth(FormattedCharSequence text) {
        return TEXT_RENDERER.width(text);
    }

    public static MultiBufferSource.BufferSource getVertexConsumer() {
        return Minecraft.getInstance().renderBuffers().bufferSource();
    }

    public static Scaler createScaler(double anchorX, double anchorY, double factor) {
        return new Scaler(anchorX, anchorY, factor);
    }

    static {
        Objects.requireNonNull(TEXT_RENDERER);
        TEXT_HEIGHT = 9;
        TEXT_LINE_HEIGHT = TEXT_HEIGHT + 1;
        tickDelta = 1.0f;
    }

    public static class Scaler {
        private final double anchorX;
        private final double anchorY;
        private final double factor;
        private RenderContext renderContext;

        private Scaler(double anchorX, double anchorY, double factor) {
            this.anchorX = anchorX;
            this.anchorY = anchorY;
            if (factor <= 0.0) {
                throw new IllegalArgumentException("factor should be greater than 0, but " + factor + " found");
            }
            this.factor = factor;
        }

        public double getScaleFactor() {
            return this.factor;
        }

        public void apply(RenderContext renderContext) {
            this.renderContext = renderContext;
            this.renderContext.pushMatrix();
            this.renderContext.translate(-this.anchorX * this.factor, -this.anchorY * this.factor, 0.0);
            this.renderContext.scale(this.factor, this.factor, 1.0);
            this.renderContext.translate(this.anchorX / this.factor, this.anchorY / this.factor, 0.0);
        }

        public void restore() {
            if (this.renderContext == null) {
                throw new RuntimeException("RenderUtils.Scaler: Calling restore before calling apply");
            }
            this.renderContext.popMatrix();
        }

        public RenderContext getRenderContext() {
            return Objects.requireNonNull(this.renderContext);
        }
    }
}

