/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.gui;

import fi.dy.masa.malilib.gui.widgets.WidgetLabel;
import java.util.Arrays;
import java.util.function.Function;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.util.StringUtils;

public class TweakerMoreOptionLabel
extends WidgetLabel {
    private final String[] originalLines;
    private final boolean showOriginalLines;

    public TweakerMoreOptionLabel(int x, int y, int width, int height, int textColor, String[] displayLines, String[] originalLines, Function<String, String> lineModifier) {
        super(x, y, width, height, textColor, displayLines);
        this.originalLines = originalLines;
        boolean showOriginalLines = false;
        for (int i = 0; i < this.originalLines.length; ++i) {
            String linesToDisplay = (String)this.labels.get(i);
            if (!this.originalLines[i].equals(StringUtils.removeFormattingCode(linesToDisplay))) {
                showOriginalLines = true;
            }
            this.labels.set(i, lineModifier.apply(linesToDisplay));
        }
        this.showOriginalLines = showOriginalLines;
        if (this.showOriginalLines != TweakerMoreOptionLabel.willShowOriginalLines(displayLines, originalLines)) {
            TweakerMoreMod.LOGGER.warn("Inconsistent showOriginalLines result: {} {}", (Object)this.showOriginalLines, (Object)TweakerMoreOptionLabel.willShowOriginalLines(displayLines, originalLines));
        }
    }

    public static double getConfigOriginalNameScale() {
        return TweakerMoreConfigs.CONFIG_ORIGINAL_NAME_SCALE.getDoubleValue();
    }

    public static boolean willShowOriginalLines(String[] displayLines, String[] originalLines) {
        return !Arrays.equals(originalLines, Arrays.stream(displayLines).map(x$0 -> fi.dy.masa.malilib.util.StringUtils.translate((String)x$0, (Object[])new Object[0])).map(StringUtils::removeFormattingCode).toArray(String[]::new));
    }

    public String[] getOriginalLines() {
        return this.originalLines;
    }

    public boolean shouldShowOriginalLines() {
        return this.showOriginalLines && TweakerMoreOptionLabel.getConfigOriginalNameScale() > 0.0;
    }
}

