/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors;

import com.google.common.collect.Sets;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.ItemType;
import java.util.HashSet;
import java.util.List;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.config.options.TweakerMoreConfigBooleanHotkeyed;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.IContainerProcessor;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.ProcessResult;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerItemPutBackProcessor
implements IContainerProcessor {
    @Override
    public TweakerMoreConfigBooleanHotkeyed getConfig() {
        return TweakerMoreConfigs.AUTO_PUT_BACK_EXISTED_ITEM;
    }

    @Override
    public ProcessResult process(LocalPlayer player, AbstractContainerScreen<?> containerScreen, List<Slot> allSlots, List<Slot> playerInvSlots, List<Slot> containerInvSlots) {
        HashSet inventoryItems = Sets.newHashSet();
        for (Slot containerInvSlot : containerInvSlots) {
            inventoryItems.add(new ItemType(containerInvSlot.getItem(), true, true));
        }
        int matchedCount = 0;
        int movedCount = 0;
        for (Slot playerInvSlot : playerInvSlots) {
            ItemStack stack = playerInvSlot.getItem();
            if (stack.isEmpty() || !inventoryItems.contains(new ItemType(stack, false, true))) continue;
            ++matchedCount;
            InventoryUtils.shiftClickSlot(containerScreen, (int)playerInvSlot.index);
            if (playerInvSlot.hasItem()) continue;
            ++movedCount;
        }
        String color = matchedCount > 0 ? (movedCount == matchedCount ? GuiBase.TXT_GREEN : GuiBase.TXT_GOLD) : GuiBase.TXT_RED;
        String percentage = String.format("%s%d/%d%s", color, movedCount, matchedCount, GuiBase.TXT_RST);
        InfoUtils.printActionbarMessage((String)"tweakermore.impl.autoPutBackExistedItem.result", (Object[])new Object[]{percentage, containerScreen.getTitle()});
        return ProcessResult.terminated();
    }
}

