/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.copySignTextToClipBoard;

import com.google.common.base.Joiner;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.Arrays;
import java.util.stream.Collectors;
import me.fallenbreath.tweakermore.util.EntityUtils;
import me.fallenbreath.tweakermore.util.compat.litematica.LitematicaUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class SignTextCopier {
    public static void copySignText() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = EntityUtils.getCurrentPlayerOrFreeCameraEntity();
        if (player != null && mc.level != null) {
            BlockPos blockPos = null;
            SignBlockEntity blockEntity = null;
            String copiedTextKey = null;
            if (LitematicaUtils.isRenderingEnabled()) {
                blockPos = LitematicaUtils.getSchematicWorldCrosshairTargetPos((Entity)player);
                blockEntity = SignTextCopier.tryGetSignBlockEntity(LitematicaUtils.getSchematicWorld(), blockPos);
                copiedTextKey = "sign_copied_schematic";
            }
            if (blockEntity == null && mc.hitResult != null && mc.hitResult.getType() == HitResult.Type.BLOCK) {
                blockPos = ((BlockHitResult)mc.hitResult).getBlockPos();
                blockEntity = SignTextCopier.tryGetSignBlockEntity((Level)mc.level, blockPos);
                copiedTextKey = "sign_copied";
            }
            if (blockEntity != null) {
                BlockState blockState = blockEntity.getBlockState();
                Component[] texts = SignTextCopier.getSignTexts(blockEntity, player);
                String text = Joiner.on((String)"\n").join((Iterable)Arrays.stream(texts).map(Component::getString).collect(Collectors.toList()));
                if (!text.isEmpty()) {
                    mc.keyboardHandler.setClipboard(text);
                    InfoUtils.printActionbarMessage((String)("tweakermore.impl.copySignTextToClipBoard." + copiedTextKey), (Object[])new Object[]{blockState.getBlock().getName()});
                } else {
                    InfoUtils.printActionbarMessage((String)"tweakermore.impl.copySignTextToClipBoard.empty_sign", (Object[])new Object[]{blockState.getBlock().getName()});
                }
                return;
            }
        }
        InfoUtils.printActionbarMessage((String)"tweakermore.impl.copySignTextToClipBoard.no_sign", (Object[])new Object[0]);
    }

    private static Component[] getSignTexts(SignBlockEntity blockEntity, LocalPlayer player) {
        return blockEntity.getText(blockEntity.isFacingFrontText((Player)player)).getMessages(false);
    }

    @Nullable
    private static SignBlockEntity tryGetSignBlockEntity(@Nullable Level world, @Nullable BlockPos pos) {
        BlockEntity blockEntity;
        BlockState blockState;
        if (world != null && pos != null && (blockState = world.getBlockState(pos)).getBlock() instanceof SignBlock && (blockEntity = world.getBlockEntity(pos)) instanceof SignBlockEntity) {
            return (SignBlockEntity)blockEntity;
        }
        return null;
    }
}

