/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.fallenbreath.tweakermore.util.PositionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ScanningCache {
    private final Map<Double, HitResult> rayTraceCache = Maps.newHashMap();
    private final Map<BeamKey, Collection<BlockPos>> beamCache = Maps.newHashMap();
    private final Map<Pair<Vec3, Vec3>, Collection<BlockPos>> boxCache = Maps.newHashMap();
    private final Map<Pair<Vec3, Double>, Collection<BlockPos>> sphereCache = Maps.newHashMap();

    @Nullable
    public HitResult crossHairTarget(double reach) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return null;
        }
        return this.rayTraceCache.computeIfAbsent(reach, k -> {
            LocalPlayer player = mc.player;
            return player.clientLevel.clip(new ClipContext(player.getEyePosition(), player.getLookAngle().normalize().scale(reach).add(player.getEyePosition()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        });
    }

    @Nullable
    public BlockPos crossHairTargetBlock(double reach) {
        HitResult hitResult = this.crossHairTarget(reach);
        return hitResult instanceof BlockHitResult ? ((BlockHitResult)hitResult).getBlockPos() : null;
    }

    public Collection<BlockPos> beam(Vec3 startPos, Vec3 endPos, double coneAngle, PositionUtils.BeamMode mode) {
        BeamKey key = new BeamKey(startPos, endPos, coneAngle, mode);
        return this.beamCache.computeIfAbsent(key, k -> PositionUtils.beam(startPos, endPos, coneAngle, mode));
    }

    public Collection<BlockPos> box(Vec3 center, double radius) {
        return this.box(center.add(-radius, -radius, -radius), center.add(radius, radius, radius));
    }

    public Collection<BlockPos> box(Vec3 pos1, Vec3 pos2) {
        return this.boxCache.computeIfAbsent((Pair<Vec3, Vec3>)Pair.of((Object)pos1, (Object)pos2), k -> {
            ArrayList result = Lists.newArrayList();
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)PositionUtils.floored(pos1), (BlockPos)PositionUtils.floored(pos2))) {
                result.add(pos.immutable());
            }
            return result;
        });
    }

    public Collection<BlockPos> sphere(Vec3 center, double radius) {
        return this.sphereCache.computeIfAbsent((Pair<Vec3, Double>)Pair.of((Object)center, (Object)radius), k -> this.box(center, radius).stream().filter(pos -> PositionUtils.centerOf(pos).distanceToSqr(center) <= radius * radius).collect(Collectors.toList()));
    }

    private static class BeamKey {
        private final Vec3 startPos;
        private final Vec3 endPos;
        private final double coneAngle;
        private final PositionUtils.BeamMode mode;

        private BeamKey(Vec3 startPos, Vec3 endPos, double coneAngle, PositionUtils.BeamMode mode) {
            this.startPos = startPos;
            this.endPos = endPos;
            this.coneAngle = coneAngle;
            this.mode = mode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BeamKey key = (BeamKey)o;
            return Double.compare(this.coneAngle, key.coneAngle) == 0 && Objects.equals(this.startPos, key.startPos) && Objects.equals(this.endPos, key.endPos) && this.mode == key.mode;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.startPos, this.endPos, this.coneAngle, this.mode});
        }
    }
}

