/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView.cache;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Optional;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.SimpleWorldView;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleCachedWorldView
implements SimpleWorldView {
    private final Level world;
    private final Long2ObjectOpenHashMap<LevelChunk> chunkCache = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<BlockState> blockStateCache = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<FluidState> fluidStateCache = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<Optional<BlockEntity>> blockEntityCache = new Long2ObjectOpenHashMap();

    public SimpleCachedWorldView(Level world) {
        this.world = world;
    }

    public Level getLevel() {
        return this.world;
    }

    public LevelChunk getChunk(BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        return (LevelChunk)this.chunkCache.computeIfAbsent(chunkPos.toLong(), k -> this.world.getChunk(chunkPos.x, chunkPos.z));
    }

    @NotNull
    public BlockState getBlockState(BlockPos blockPos) {
        return (BlockState)this.blockStateCache.computeIfAbsent(blockPos.asLong(), bp -> this.getChunk(blockPos).getBlockState(blockPos));
    }

    @NotNull
    public FluidState getFluidState(BlockPos blockPos) {
        return (FluidState)this.fluidStateCache.computeIfAbsent(blockPos.asLong(), bp -> this.getChunk(blockPos).getFluidState(blockPos));
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos blockPos) {
        return ((Optional)this.blockEntityCache.computeIfAbsent(blockPos.asLong(), bp -> Optional.ofNullable(this.getChunk(blockPos).getBlockEntity(blockPos)))).orElse(null);
    }

    public int getHeight() {
        return this.world.getHeight();
    }

    public int getMinY() {
        return this.world.getMinY();
    }

    @Override
    public int getLightLevel(BlockPos pos) {
        return this.world.getBrightness(LightLayer.BLOCK, pos);
    }

    @Override
    public int getLightLevel(LightLayer type, BlockPos pos) {
        return this.world.getBrightness(type, pos);
    }

    @Override
    public int getBaseLightLevel(BlockPos pos, int ambientDarkness) {
        return this.world.getRawBrightness(pos, ambientDarkness);
    }
}

