/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.safeAfk;

import java.text.SimpleDateFormat;
import java.util.Date;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.util.Messenger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;

public class SafeAfkHelper {
    private static long lastHurtMs = 0L;
    private static final long MAX_TIME_WAIT = 15000L;

    public static void resetHurtTime() {
        lastHurtMs = -15000L;
    }

    public static void recordHurtTime() {
        lastHurtMs = System.currentTimeMillis();
    }

    public static boolean hasRecord() {
        return System.currentTimeMillis() - lastHurtMs <= 15000L;
    }

    public static void onHealthUpdate(Minecraft mc) {
        if (TweakerMoreConfigs.SAFE_AFK.getBooleanValue() && mc.player != null && mc.level != null && SafeAfkHelper.hasRecord()) {
            float health = mc.player.getHealth();
            float maxHealth = mc.player.getMaxHealth();
            if (maxHealth > 0.0f && (double)health < TweakerMoreConfigs.SAFE_AFK_HEALTH_THRESHOLD.getDoubleValue()) {
                MutableComponent title = Messenger.s("TweakerMore " + TweakerMoreConfigs.SAFE_AFK.getPrettyName());
                MutableComponent reason = Messenger.tr("tweakermore.impl.safeAfk.received_damage", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()), String.format("%.1f / %.1f (%.0f%%)", Float.valueOf(health), Float.valueOf(maxHealth), Float.valueOf(health / maxHealth * 100.0f)));
                SafeAfkHelper.resetHurtTime();
                mc.execute(() -> SafeAfkHelper.lambda$onHealthUpdate$0(mc, (Component)title, (Component)reason));
            }
        }
    }

    public static void onEntityEnterDamageStatus(LivingEntity livingEntity) {
        if (TweakerMoreConfigs.SAFE_AFK.getBooleanValue()) {
            Minecraft mc = Minecraft.getInstance();
            if (livingEntity == mc.player && mc.level != null) {
                SafeAfkHelper.recordHurtTime();
            }
        }
    }

    private static /* synthetic */ void lambda$onHealthUpdate$0(Minecraft mc, Component title, Component reason) {
        mc.level.disconnect();
        mc.disconnect();
        mc.setScreen((Screen)new DisconnectedScreen((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()), title, reason));
    }
}

