/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxItemContentHint;

import com.mojang.blaze3d.vertex.PoseStack;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxItemContentHint.ShulkerBoxItemContentHintCommon;
import me.fallenbreath.tweakermore.util.render.ColorHolder;
import me.fallenbreath.tweakermore.util.render.RenderUtils;
import me.fallenbreath.tweakermore.util.render.context.RenderContext;
import me.fallenbreath.tweakermore.util.render.context.RenderGlobals;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class ShulkerBoxItemContentHintRenderer {
    private static final int SLOT_WIDTH = 16;
    static final ThreadLocal<Boolean> isRendering = ThreadLocal.withInitial(() -> false);

    public static void render(PoseStack poseStack, GuiGraphics drawContext, ItemStack itemStack, int x, int y) {
        boolean mixedBox;
        ShulkerBoxItemContentHintCommon.Info info = ShulkerBoxItemContentHintCommon.prepareInformation(itemStack);
        if (!info.enabled) {
            return;
        }
        PoseStack textMatrixStack = poseStack;
        textMatrixStack.pushPose();
        RenderContext renderContext = RenderContext.of(drawContext);
        RenderUtils.Scaler scaler = RenderUtils.createScaler(x, y + 16, info.scale);
        scaler.apply(renderContext);
        if (info.allItemSame || info.allItemSameIgnoreNbt) {
            ShulkerBoxItemContentHintRenderer.renderMiniItem(renderContext, drawContext, info, x, y);
        }
        if (!info.allItemSame) {
            ShulkerBoxItemContentHintRenderer.renderText(textMatrixStack, 160.0, info, x, y);
        }
        scaler.restore();
        boolean bl = mixedBox = !info.allItemSameIgnoreNbt && !info.allItemSame;
        if ((!mixedBox || TweakerMoreConfigs.SHULKER_BOX_ITEM_CONTENT_HINT_SHOW_BAR_ON_MIXED.getBooleanValue()) && 0.0 < info.fillRatio && info.fillRatio < 1.0) {
            ShulkerBoxItemContentHintRenderer.renderBar(renderContext, info.fillRatio, x, y);
        }
        textMatrixStack.popPose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderMiniItem(RenderContext renderContext, GuiGraphics drawContext, ShulkerBoxItemContentHintCommon.Info info, int x, int y) {
        isRendering.set(true);
        try {
            renderContext.getMatrixStack().pushMatrix();
            renderContext.getMatrixStack().translate(0.0, 0.0, 10.0);
            drawContext.renderItem(info.stack, x, y);
        }
        finally {
            isRendering.set(false);
            renderContext.getMatrixStack().popMatrix();
        }
    }

    private static void renderText(PoseStack textMatrixStack, double zOffset, ShulkerBoxItemContentHintCommon.Info info, int x, int y) {
        String text = info.allItemSameIgnoreNbt ? "*" : "...";
        boolean putTextOnRight = info.allItemSameIgnoreNbt && info.scale <= 0.75;
        float width = RenderUtils.getRenderWidth(text);
        float height = RenderUtils.TEXT_HEIGHT;
        float textX = putTextOnRight ? (float)(x + 16) + 0.5f : (float)x + (16.0f - width) * 0.5f;
        float textY = putTextOnRight ? (float)y + (16.0f - height) * 0.5f : (float)(y + 16) - height - 3.0f;
        double textScale = (double)(16.0f / height) * 0.7 * (putTextOnRight ? 0.9 : 1.0);
        int textColor = 0xDDDDDD;
        RenderUtils.Scaler textScaler = RenderUtils.createScaler((double)textX + (double)width * 0.5, (double)textY + (double)height * 0.5, textScale);
        textScaler.apply(RenderContext.of(textMatrixStack));
        Font textRenderer = Minecraft.getInstance().font;
        textMatrixStack.translate(0.0f, 0.0f, (float)zOffset);
        MultiBufferSource.BufferSource immediate = RenderUtils.getVertexConsumer();
        textRenderer.drawInBatch(text, textX, textY, textColor, true, textMatrixStack.last().pose(), (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        immediate.endBatch();
        textScaler.restore();
    }

    private static void renderBar(RenderContext renderContext, double fillRatio, int x, int y) {
        int HEIGHT = 8;
        boolean WIDTH = true;
        x = x + 16 - 1;
        y = y + 16 - 8;
        RenderGlobals.disableDepthTest();
        int h = (int)Math.round(fillRatio * 8.0);
        int color = Mth.hsvToRgb((float)((float)(fillRatio / 3.0)), (float)1.0f, (float)1.0f);
        if (h == 0) {
            h = 1;
            ColorHolder holder = ColorHolder.of(color);
            holder.red /= 2;
            holder.green /= 2;
            holder.blue /= 2;
            color = holder.pack();
        }
        GuiQuadDrawer drawer = (x_, y_, width_, height_, color_) -> renderContext.getGuiDrawer().fill(RenderType.guiOverlay(), x_, y_, x_ + width_, y_ + height_, color_ | 0xFF000000);
        drawer.draw(x, y, 1, 8, 263172);
        drawer.draw(x, y + 8 - h, 1, h, color);
        RenderGlobals.enableDepthTest();
    }

    @FunctionalInterface
    private static interface GuiQuadDrawer {
        public void draw(int var1, int var2, int var3, int var4, int var5);
    }
}

