/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mod_tweaks.lmRemoveEntityCommand;

import com.mojang.brigadier.tree.CommandNode;
import fi.dy.masa.malilib.config.options.ConfigString;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.Collections;
import java.util.Optional;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.config.options.listentries.LitematicaRemoveEntityCommandPolicy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;

public class LitematicaRemoveEntityCommandOverrider {
    public static final String DEFAULT_COMMAND = "kill";

    public static void onCommandOverrideChanged(ConfigString configString) {
        assert (configString == TweakerMoreConfigs.LM_REMOVE_ENTITY_COMMAND);
        String command = TweakerMoreConfigs.LM_REMOVE_ENTITY_COMMAND.getStringValue();
        if (!command.isEmpty()) {
            LitematicaRemoveEntityCommandOverrider.isCommandValid(command).ifPresent(valid -> {
                if (!valid.booleanValue()) {
                    InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.WARNING, (String)"tweakermore.impl.lmRemoveEntityCommand.invalid_command", (Object[])new Object[]{command});
                }
            });
        }
    }

    private static Optional<Boolean> isCommandValid(String command) {
        ClientPacketListener networkHandler = Minecraft.getInstance().getConnection();
        if (networkHandler != null) {
            CommandNode node = networkHandler.commands.findNode(Collections.singleton(command));
            return Optional.of(node != null && node.canUse((Object)networkHandler.getSuggestionsProvider()));
        }
        return Optional.empty();
    }

    public static String applyOverride(String commandFormatter) {
        if (TweakerMoreConfigs.LM_REMOVE_ENTITY_COMMAND.isModified()) {
            if (commandFormatter.contains(DEFAULT_COMMAND)) {
                String command = TweakerMoreConfigs.LM_REMOVE_ENTITY_COMMAND.getStringValue();
                if (LitematicaRemoveEntityCommandOverrider.isCommandValid(command).orElse(false).booleanValue() || TweakerMoreConfigs.LM_REMOVE_ENTITY_COMMAND_POLICY.getOptionListValue() == LitematicaRemoveEntityCommandPolicy.ALWAYS) {
                    commandFormatter = commandFormatter.replaceFirst(DEFAULT_COMMAND, command);
                }
            } else {
                TweakerMoreMod.LOGGER.warn("Command formatter {} doesn't contain \"{}\"", (Object)commandFormatter, (Object)DEFAULT_COMMAND);
            }
        }
        return commandFormatter;
    }
}

