/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import me.fallenbreath.tweakermore.mixins.tweaks.mod_tweaks.serverDataSyncer.DataQueryHandlerAccessor;
import me.fallenbreath.tweakermore.util.collection.ExpiringMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundBlockEntityTagQueryPacket;
import net.minecraft.network.protocol.game.ServerboundEntityTagQueryPacket;
import org.jetbrains.annotations.Nullable;

public class DataQueryHandlerPro {
    private final Map<Integer, Callback> callbacks = new ExpiringMap<Integer, Callback>(Maps.newHashMap(), 30000);
    private int idCounter = 0;

    private static Optional<ClientPacketListener> getNetworkHandler() {
        ClientPacketListener clientPacketListener = Minecraft.getInstance().getConnection();
        return clientPacketListener != null ? Optional.of(clientPacketListener) : Optional.empty();
    }

    public int generateTransactionId(ClientPacketListener networkHandler) {
        DataQueryHandlerAccessor accessor = (DataQueryHandlerAccessor)networkHandler.getDebugQueryHandler();
        int id = (accessor.getTransactionId() ^ Integer.MIN_VALUE) + this.idCounter;
        this.idCounter = (this.idCounter + 1) % 0x100000;
        return id;
    }

    public boolean handleQueryResponse(int transactionId, @Nullable CompoundTag tag) {
        Callback callback = this.callbacks.remove(transactionId);
        if (callback != null) {
            callback.accept(tag);
            return true;
        }
        return false;
    }

    private int nextQuery(ClientPacketListener networkHandler, Callback callback) {
        int transactionId = this.generateTransactionId(networkHandler);
        this.callbacks.put(transactionId, callback);
        return transactionId;
    }

    public void clearCallbacks() {
        this.callbacks.clear();
    }

    public void queryEntityNbt(int entityNetworkId, Callback callback) {
        DataQueryHandlerPro.getNetworkHandler().ifPresent(networkHandler -> {
            int id = this.nextQuery((ClientPacketListener)networkHandler, callback);
            networkHandler.send((Packet)new ServerboundEntityTagQueryPacket(id, entityNetworkId));
        });
    }

    public void queryBlockNbt(BlockPos pos, Callback callback) {
        DataQueryHandlerPro.getNetworkHandler().ifPresent(networkHandler -> {
            int id = this.nextQuery((ClientPacketListener)networkHandler, callback);
            networkHandler.send((Packet)new ServerboundBlockEntityTagQueryPacket(id, pos));
        });
    }

    @FunctionalInterface
    public static interface Callback {
        public void accept(@Nullable CompoundTag var1);
    }
}

