/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class EntityMotionStateRestorer {
    private final Entity entity;
    private final Vec3 pos;
    private final Vec3 prevPos;
    private final Vec3 lastRenderPos;
    private final Vec3 velocity;
    private final float yaw;
    private final float headYaw;
    private final float bodyYaw;
    private final float prevYaw;
    private final float prevBodyYaw;
    private final float prevHeadYaw;
    private final float pitch;
    private final float prevPitch;

    public EntityMotionStateRestorer(Entity entity) {
        this.entity = entity;
        this.pos = new Vec3(entity.getX(), entity.getY(), entity.getZ());
        this.prevPos = new Vec3(entity.xo, entity.yo, entity.zo);
        this.lastRenderPos = new Vec3(entity.xOld, entity.yOld, entity.zOld);
        this.velocity = entity.getDeltaMovement();
        this.yaw = entity.getYRot();
        this.pitch = entity.getXRot();
        this.headYaw = entity.getYHeadRot();
        this.bodyYaw = entity instanceof LivingEntity ? ((LivingEntity)entity).yBodyRot : 0.0f;
        this.prevYaw = entity.yRotO;
        this.prevBodyYaw = entity instanceof LivingEntity ? ((LivingEntity)entity).yBodyRotO : 0.0f;
        this.prevHeadYaw = entity instanceof LivingEntity ? ((LivingEntity)entity).yHeadRotO : 0.0f;
        this.prevPitch = entity.xRotO;
    }

    public void restore() {
        this.entity.setPos(this.pos.x, this.pos.y, this.pos.z);
        this.entity.xo = this.prevPos.x;
        this.entity.yo = this.prevPos.y;
        this.entity.zo = this.prevPos.z;
        this.entity.xOld = this.lastRenderPos.x;
        this.entity.yOld = this.lastRenderPos.y;
        this.entity.zOld = this.lastRenderPos.z;
        this.entity.setDeltaMovement(this.velocity);
        this.entity.setYRot(this.yaw);
        this.entity.setXRot(this.pitch);
        this.entity.yRotO = this.prevYaw;
        this.entity.setYRot(this.yaw);
        this.entity.setYHeadRot(this.headYaw);
        this.entity.xRotO = this.prevPitch;
        if (this.entity instanceof LivingEntity) {
            ((LivingEntity)this.entity).yBodyRot = this.bodyYaw;
            ((LivingEntity)this.entity).yBodyRotO = this.prevBodyYaw;
            ((LivingEntity)this.entity).yHeadRotO = this.prevHeadYaw;
        }
    }
}

