/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.mixins.tweaks.features.pistorder;

import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.features.pistorder.PistorderRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Restriction(conflict={@Condition(value="pistorder", versionPredicates={"<=1.6.0"})})
@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class AbstractBlockStateMixin {
    @Inject(method={"useItemOn"}, at={@At(value="HEAD")}, cancellable=true)
    private void tkmPistorder_onPlayerRightClickBlock(ItemStack itemStack, Level world, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        if (!PistorderRenderer.getInstance().isEnabled()) {
            return;
        }
        if (world.isClientSide) {
            boolean ok;
            InteractionResult result = PistorderRenderer.getInstance().onPlayerRightClickBlockWithMainHand(world, player, hit);
            boolean bl = ok = result == InteractionResult.SUCCESS;
            if (ok && TweakerMoreConfigs.PISTORDER_SWING_HAND.getBooleanValue()) {
                cir.setReturnValue((Object)result);
            }
        }
    }
}

