/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.mixins.tweaks.mc_tweaks.fixHoverTextScale;

import me.fallenbreath.tweakermore.impl.mc_tweaks.fixHoverTextScale.ScaleableHoverTextRenderer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class})
public abstract class HoverTextRendererClassMixin
implements ScaleableHoverTextRenderer {
    @Unique
    private Double hoverTextScale = null;

    @Override
    public void setHoverTextScale$TKM(@Nullable Double scale) {
        this.hoverTextScale = scale != null ? Double.valueOf(Mth.clamp((double)scale, (double)0.01, (double)1.0)) : null;
    }

    @Inject(method={"renderComponentHoverEffect"}, at={@At(value="TAIL")})
    private void fixHoverTextScale_cleanup(CallbackInfo ci) {
        this.hoverTextScale = null;
    }

    @ModifyArg(method={"renderComponentHoverEffect"}, at=@At(value="INVOKE", target="Ljava/lang/Math;max(II)I"), index=0)
    private int fixHoverTextScale_modifyEquivalentMaxScreenWidth(int width) {
        if (this.hoverTextScale != null) {
            width = (int)((double)width / this.hoverTextScale);
        }
        return width;
    }

    @ModifyVariable(method={"renderTooltipInternal"}, at=@At(value="HEAD"), argsOnly=true)
    private ClientTooltipPositioner fixHoverTextScale_modifyPositioner(ClientTooltipPositioner positioner) {
        if (this.hoverTextScale != null) {
            double scale = this.hoverTextScale;
            positioner = (screenWidth, screenHeight, x, y, width, height) -> {
                x += 12;
                y -= 12;
                if ((double)x + (double)width * scale > (double)screenWidth) {
                    x = Math.max(x - 24 - width, 4);
                }
                if ((double)y + (double)height * scale + 6.0 > (double)screenHeight) {
                    y += (int)((double)(screenHeight - y - 12 - 1) / scale - (double)height + 6.0);
                }
                return new Vector2i(x, y);
            };
        }
        return positioner;
    }
}

