/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.mixins.tweaks.mc_tweaks.weatherOverride;

import java.util.function.Function;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.config.options.listentries.WeatherOverrideValue;
import me.fallenbreath.tweakermore.impl.mc_tweaks.weatherOverride.WeatherOverrideHelper;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public abstract class WorldMixin {
    @Inject(method={"getRainLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void weatherOverride_overrideRain(CallbackInfoReturnable<Float> cir) {
        this.weatherOverride_common(cir, WeatherOverrideValue::getRainGradient);
    }

    @Inject(method={"getThunderLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void weatherOverride_overrideThunder(CallbackInfoReturnable<Float> cir) {
        this.weatherOverride_common(cir, WeatherOverrideValue::getThunderGradient);
    }

    @Unique
    private void weatherOverride_common(CallbackInfoReturnable<Float> cir, Function<WeatherOverrideValue, Float> overrider) {
        if (TweakerMoreConfigs.WEATHER_OVERRIDE.getBooleanValue()) {
            if (WeatherOverrideHelper.disableOverride.get().booleanValue()) {
                return;
            }
            Level self = (Level)this;
            if (self instanceof ClientLevel) {
                WeatherOverrideValue value = (WeatherOverrideValue)TweakerMoreConfigs.WEATHER_OVERRIDE_VALUE.getOptionListValue();
                cir.setReturnValue((Object)overrider.apply(value));
            }
        }
    }
}

