/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util;

import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class IdentifierUtils {
    public static ResourceLocation of(String id) {
        return ResourceLocation.parse((String)id);
    }

    public static ResourceLocation of(String namespace, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static Optional<ResourceLocation> tryParse(String id) {
        try {
            return Optional.of(IdentifierUtils.of(id));
        }
        catch (ResourceLocationException e) {
            return Optional.empty();
        }
    }

    @Nullable
    public static ResourceLocation tryParseOrNull(String id) {
        return IdentifierUtils.tryParse(id).orElse(null);
    }
}

