/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView.growthSpeed.handlers;

import java.util.List;
import java.util.Optional;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.RenderVisitorWorldView;
import me.fallenbreath.tweakermore.impl.features.infoView.growthSpeed.handlers.BasicGrowthSpeedRendererHandler;
import me.fallenbreath.tweakermore.mixins.tweaks.features.infoView.growthSpeed.AttachedStemBlockAccessor;
import me.fallenbreath.tweakermore.mixins.tweaks.features.infoView.growthSpeed.CropBlockAccessor;
import me.fallenbreath.tweakermore.util.Messenger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.PitcherCropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class CropGrowthSpeedRendererHandler
extends BasicGrowthSpeedRendererHandler {
    @Override
    public boolean isTarget(BlockState blockState) {
        Block block = blockState.getBlock();
        return block instanceof CropBlock || block instanceof StemBlock || block instanceof AttachedStemBlock || block instanceof PitcherCropBlock && blockState.getValue((Property)PitcherCropBlock.HALF) == DoubleBlockHalf.LOWER;
    }

    @Override
    public void addInfoLines(RenderVisitorWorldView world, BlockPos pos, boolean isCrossHairPos, List<MutableComponent> lines) {
        boolean lightOk;
        Optional optional;
        Block block;
        Block cropBlock = block = world.getBlockState(pos).getBlock();
        if (block instanceof AttachedStemBlockAccessor && (optional = world.getBestWorld().registryAccess().get(((AttachedStemBlockAccessor)block).getStem())).isPresent()) {
            cropBlock = (Block)((Holder.Reference)optional.get()).value();
        }
        float baseSpeed = CropBlockAccessor.invokeGetAvailableMoisture(cropBlock.defaultBlockState(), world, pos);
        BasicGrowthSpeedRendererHandler.Attributes attributes = new BasicGrowthSpeedRendererHandler.Attributes();
        ChatFormatting color = CropGrowthSpeedRendererHandler.heatColor((double)baseSpeed / 10.0);
        attributes.add(CropGrowthSpeedRendererHandler.tr("crop.base", new Object[0]), Messenger.s(CropGrowthSpeedRendererHandler.round(baseSpeed, 6), color));
        int randomBound = (int)(25.0f / baseSpeed) + 1;
        attributes.add(CropGrowthSpeedRendererHandler.tr("crop.chance", new Object[0]), Messenger.s("1/" + randomBound, color));
        int light = world.getBaseLightLevel(pos, 0);
        boolean lightToLiveOk = light >= this.getMinimumRequiredLightLevelToSurvive(cropBlock);
        boolean lightToGrowOk = light >= this.getMinimumRequiredLightLevelToGrowNaturally(cropBlock);
        boolean bl = lightOk = lightToLiveOk && lightToGrowOk;
        ChatFormatting lightColor = lightOk ? ChatFormatting.GREEN : (lightToLiveOk ? ChatFormatting.GOLD : ChatFormatting.RED);
        MutableComponent value = Messenger.c(Messenger.s(light + " ", lightColor), CropGrowthSpeedRendererHandler.bool(lightOk, lightColor));
        attributes.add(CropGrowthSpeedRendererHandler.tr("crop.light", new Object[0]), value, lightOk);
        attributes.export(lines, isCrossHairPos);
    }

    private int getMinimumRequiredLightLevelToGrowNaturally(Block block) {
        if (block instanceof PitcherCropBlock) {
            return 8;
        }
        return 9;
    }

    private int getMinimumRequiredLightLevelToSurvive(Block block) {
        return 8;
    }
}

