/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mc_tweaks.connectionSimulatedDelay;

import com.google.common.collect.Queues;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;

class DelayedRunner {
    private final Timer timer = new HashedWheelTimer(10L, TimeUnit.MILLISECONDS);
    private final Queue<Runnable> queue = Queues.newConcurrentLinkedQueue();

    DelayedRunner() {
    }

    public void delayedRun(Function<Integer, Integer> delayTransformer, Runnable task) {
        int optionValue = TweakerMoreConfigs.CONNECTION_SIMULATED_DELAY.getIntegerValue();
        int delayMs = delayTransformer.apply(optionValue);
        if (delayMs > 0 && TweakerMoreConfigs.CONNECTION_SIMULATED_DELAY.isModified()) {
            this.queue.add(task);
            this.timer.newTimeout(t -> this.queue.remove().run(), (long)delayMs, TimeUnit.MILLISECONDS);
        } else {
            task.run();
        }
    }
}

