/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer;

import com.google.common.collect.Sets;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.util.PositionUtils;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer.TargetPair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class AreaSelectionUtil {
    public static TargetPair extractBlockEntitiesAndEntities(Box box, boolean saveableOnly) {
        Minecraft mc = Minecraft.getInstance();
        ClientPacketListener networkHandler = mc.getConnection();
        if (networkHandler == null || mc.player == null) {
            return TargetPair.none();
        }
        BlockPos pos1 = box.getPos1();
        BlockPos pos2 = box.getPos2();
        if (pos1 == null || pos2 == null) {
            return TargetPair.none();
        }
        int minX = Math.min(pos1.getX(), pos2.getX());
        int minY = Math.min(pos1.getY(), pos2.getY());
        int minZ = Math.min(pos1.getZ(), pos2.getZ());
        int maxX = Math.max(pos1.getX(), pos2.getX());
        int maxY = Math.max(pos1.getY(), pos2.getY());
        int maxZ = Math.max(pos1.getZ(), pos2.getZ());
        ClientLevel world = mc.player.clientLevel;
        List<BlockPos> bePositions = BlockPos.betweenClosedStream((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ).map(BlockPos::immutable).filter(arg_0 -> AreaSelectionUtil.lambda$extractBlockEntitiesAndEntities$0((Level)world, arg_0)).collect(Collectors.toList());
        AABB aabb = new AABB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
        List entities = world.getEntities((Entity)null, aabb, saveableOnly ? entity -> entity.getType().canSerialize() : null);
        return TargetPair.of(bePositions, entities);
    }

    public static TargetPair extractBlockEntitiesAndEntities(AreaSelection area, boolean saveableOnly) {
        LinkedHashSet bePositions = Sets.newLinkedHashSet();
        LinkedHashSet entities = Sets.newLinkedHashSet();
        PositionUtils.getValidBoxes((AreaSelection)area).forEach(box -> {
            TargetPair pair = AreaSelectionUtil.extractBlockEntitiesAndEntities(box, saveableOnly);
            bePositions.addAll(pair.getBlockEntityPositions());
            entities.addAll(pair.getEntities());
        });
        return TargetPair.of(bePositions, entities);
    }

    private static /* synthetic */ boolean lambda$extractBlockEntitiesAndEntities$0(Level world, BlockPos blockPos) {
        BlockState blockState = world.getBlockState(blockPos);
        return blockState.hasBlockEntity();
    }
}

