/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util;

import java.util.Collection;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class PlatformUtils {
    public static boolean isModLoaded(String modId) {
        if (ModList.get() == null) {
            return LoadingModList.get().getMods().stream().map(ModInfo::getModId).anyMatch(modId::equals);
        }
        return ModList.get().isLoaded(modId);
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    public static boolean doesModFitsAnyPredicate(String modId, Collection<String> versionPredicates) {
        if (!PlatformUtils.isModLoaded(modId)) {
            return false;
        }
        if (ModList.get() == null) {
            DefaultArtifactVersion version = modId.equals("minecraft") ? new DefaultArtifactVersion(FMLLoader.versionInfo().mcVersion()) : LoadingModList.get().getModFileById(modId).getFile().getJarVersion();
            return versionPredicates.isEmpty() || versionPredicates.stream().anyMatch(arg_0 -> PlatformUtils.lambda$doesModFitsAnyPredicate$0((ArtifactVersion)version, arg_0));
        }
        return ModList.get().getModContainerById(modId).map(mod -> {
            DefaultArtifactVersion version = modId.equals("minecraft") ? new DefaultArtifactVersion(FMLLoader.versionInfo().mcVersion()) : mod.getModInfo().getVersion();
            return versionPredicates.isEmpty() || versionPredicates.stream().anyMatch(arg_0 -> PlatformUtils.lambda$doesModFitsAnyPredicate$1((ArtifactVersion)version, arg_0));
        }).orElse(false);
    }

    public static boolean doesVersionSatisfyPredicate(ArtifactVersion version, String versionPredicate) {
        try {
            if (versionPredicate.contains("=")) {
                if (versionPredicate.contains("<")) {
                    String[] target = versionPredicate.split("=")[1].split("\\.");
                    if (version.getMajorVersion() > Integer.parseInt(target[0])) {
                        return false;
                    }
                    if (version.getMinorVersion() > Integer.parseInt(target[1])) {
                        return false;
                    }
                    return target.length == 2 || version.getIncrementalVersion() <= Integer.parseInt(target[2]);
                }
                if (versionPredicate.contains(">")) {
                    String[] target = versionPredicate.split("=")[1].split("\\.");
                    if (version.getMajorVersion() < Integer.parseInt(target[0])) {
                        return false;
                    }
                    if (version.getMinorVersion() < Integer.parseInt(target[1])) {
                        return false;
                    }
                    return target.length == 2 || version.getIncrementalVersion() >= Integer.parseInt(target[2]);
                }
                String[] target = versionPredicate.replace("=", "").split("\\.");
                return version.getMajorVersion() == Integer.parseInt(target[0]) && version.getMinorVersion() == Integer.parseInt(target[1]) && (target.length == 2 || version.getIncrementalVersion() == Integer.parseInt(target[2]));
            }
            if (versionPredicate.contains("<")) {
                String[] target = versionPredicate.replace("<", "").split("\\.");
                if (version.getMajorVersion() > Integer.parseInt(target[0])) {
                    return false;
                }
                if (version.getMinorVersion() > Integer.parseInt(target[1])) {
                    return false;
                }
                return target.length == 2 || version.getIncrementalVersion() < Integer.parseInt(target[2]);
            }
            if (versionPredicate.contains(">")) {
                String[] target = versionPredicate.replace(">", "").split("\\.");
                if (version.getMajorVersion() < Integer.parseInt(target[0])) {
                    return false;
                }
                if (version.getMinorVersion() < Integer.parseInt(target[1])) {
                    return false;
                }
                return target.length == 2 || version.getIncrementalVersion() > Integer.parseInt(target[2]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$doesModFitsAnyPredicate$1(ArtifactVersion version, String vp) {
        return PlatformUtils.doesVersionSatisfyPredicate(version, vp);
    }

    private static /* synthetic */ boolean lambda$doesModFitsAnyPredicate$0(ArtifactVersion version, String vp) {
        return PlatformUtils.doesVersionSatisfyPredicate(version, vp);
    }
}

