/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.config.options.listentries;

import java.util.function.BiPredicate;
import me.fallenbreath.tweakermore.config.options.listentries.EnumOptionEntry;

public enum RestrictionType implements EnumOptionEntry
{
    NONE,
    WHITELIST,
    BLACKLIST;


    public <T> boolean test(T target, Iterable<T> collection, BiPredicate<T, T> tester) {
        if (this == NONE) {
            throw new UnsupportedOperationException();
        }
        for (T item : collection) {
            boolean matches = tester.test(target, item);
            if (matches && this == WHITELIST) {
                return true;
            }
            if (!matches || this != BLACKLIST) continue;
            return false;
        }
        switch (this.ordinal()) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        throw new UnsupportedOperationException();
    }

    public <T> boolean testEquality(T target, Iterable<T> collection) {
        return this.test(target, collection, Object::equals);
    }

    public <T> boolean testReference(T target, Iterable<T> collection) {
        return this.test(target, collection, (a, b) -> a == b);
    }

    @Override
    public EnumOptionEntry[] getAllValues() {
        return RestrictionType.values();
    }

    @Override
    public EnumOptionEntry getDefault() {
        return NONE;
    }

    @Override
    public String getTranslationPrefix() {
        return "tweakermore.list_entry.restriction_type.";
    }
}

