/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.autoContainerProcess;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.AutoProcessableScreen;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.ContainerCleaner;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.ContainerFiller;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.ContainerItemPutBackProcessor;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.ContainerMaterialListItemCollector;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.IContainerProcessor;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.ProcessResult;
import me.fallenbreath.tweakermore.mixins.tweaks.features.autoContainerProcess.ItemScrollerInventoryUtilsAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class ContainerProcessorManager {
    private static final List<IContainerProcessor> CONTAINER_PROCESSORS = ImmutableList.of((Object)new ContainerCleaner(), (Object)new ContainerFiller(), (Object)new ContainerItemPutBackProcessor(), (Object)new ContainerMaterialListItemCollector());

    private static boolean hasTweakEnabled() {
        return CONTAINER_PROCESSORS.stream().anyMatch(IContainerProcessor::isEnabled);
    }

    public static List<IContainerProcessor> getProcessors() {
        return CONTAINER_PROCESSORS;
    }

    public static void process(AbstractContainerMenu container) {
        if (ContainerProcessorManager.hasTweakEnabled()) {
            Screen screen = Minecraft.getInstance().screen;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && screen instanceof AbstractContainerScreen) {
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                if (player.isSpectator()) {
                    return;
                }
                if (containerScreen.getMenu() != container || !((AutoProcessableScreen)screen).shouldProcess$TKM()) {
                    return;
                }
                if (ContainerProcessorManager.isInBlackList(containerScreen)) {
                    return;
                }
                ((AutoProcessableScreen)screen).setShouldProcess$TKM(false);
                NonNullList allSlots = container.slots;
                List<Slot> playerInvSlots = allSlots.stream().filter(slot -> slot.container instanceof Inventory).collect(Collectors.toList());
                if (allSlots.isEmpty() || playerInvSlots.isEmpty()) {
                    return;
                }
                List<Slot> containerInvSlots = allSlots.stream().filter(arg_0 -> ContainerProcessorManager.lambda$process$1((List)allSlots, arg_0)).collect(Collectors.toList());
                if (containerInvSlots.isEmpty()) {
                    return;
                }
                boolean closeGui = false;
                for (IContainerProcessor processor : CONTAINER_PROCESSORS) {
                    if (!processor.isEnabled()) continue;
                    ProcessResult result = processor.process(player, containerScreen, (List<Slot>)allSlots, playerInvSlots, containerInvSlots);
                    closeGui |= result.closeGui;
                    if (!result.cancelProcessing) continue;
                    break;
                }
                if (closeGui) {
                    player.closeContainer();
                }
            }
        }
    }

    private static <T extends Container> boolean isInBlackList(AbstractContainerScreen<?> containerScreen) {
        return containerScreen instanceof InventoryScreen || containerScreen instanceof CreativeModeInventoryScreen || containerScreen instanceof CraftingScreen || containerScreen instanceof MerchantScreen;
    }

    private static /* synthetic */ boolean lambda$process$1(List allSlots, Slot slot) {
        return ItemScrollerInventoryUtilsAccessor.areSlotsInSameInventory(slot, (Slot)allSlots.getFirst());
    }
}

