/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView.cache;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.SimpleCachedWorldView;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.SimpleWorldView;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderVisitorWorldView
implements SimpleWorldView {
    private final SimpleCachedWorldView bestWorldView;
    private final SimpleCachedWorldView clientWorldView;
    private final LongOpenHashSet syncBlockEntityPositions = new LongOpenHashSet();

    public RenderVisitorWorldView(SimpleCachedWorldView bestWorld, SimpleCachedWorldView clientWorld) {
        this.bestWorldView = bestWorld;
        this.clientWorldView = clientWorld;
    }

    public Level getBestWorld() {
        return this.bestWorldView.getLevel();
    }

    public Level getClientWorld() {
        return this.clientWorldView.getLevel();
    }

    public boolean isBestWorldServerWorld() {
        return this.getBestWorld() instanceof ServerLevel;
    }

    public void syncBlockEntity(BlockPos pos) {
        if (this.syncBlockEntityPositions.add(pos.asLong())) {
            this.doSyncBlockEntity(pos);
        }
    }

    private void doSyncBlockEntity(BlockPos pos) {
    }

    @NotNull
    public BlockState getBlockState(@NotNull BlockPos pos) {
        return this.clientWorldView.getBlockState(pos);
    }

    @NotNull
    public FluidState getFluidState(@NotNull BlockPos pos) {
        return this.clientWorldView.getFluidState(pos);
    }

    @Nullable
    public BlockEntity getBlockEntity(@NotNull BlockPos pos) {
        return this.bestWorldView.getBlockEntity(pos);
    }

    public int getHeight() {
        return this.clientWorldView.getHeight();
    }

    public int getMinY() {
        return this.clientWorldView.getMinY();
    }

    @Override
    public int getLightLevel(BlockPos pos) {
        return this.clientWorldView.getLightLevel(pos);
    }

    @Override
    public int getLightLevel(LightLayer type, BlockPos pos) {
        return this.clientWorldView.getLightLevel(type, pos);
    }

    @Override
    public int getBaseLightLevel(BlockPos pos, int ambientDarkness) {
        return this.clientWorldView.getBaseLightLevel(pos, ambientDarkness);
    }
}

