/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.serverMsptMetricsStatistic;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.LongStream;
import net.minecraft.util.debugchart.LocalSampleLogger;
import net.minecraft.util.profiling.metrics.MetricCategory;

public class MetricsStatistic {
    private final Type aggregationType;
    private final int aggregationLen;
    private final long[][] buffer;
    private final List<MetricsStatistic> newSampleChildren;
    private static final int COLUMN_NUM = MetricCategory.values().length;
    private LocalSampleLogger metricsData;
    private int index;

    public MetricsStatistic(Type aggregationType, int aggregationLen) {
        this.aggregationType = aggregationType;
        this.aggregationLen = aggregationLen;
        this.buffer = new long[COLUMN_NUM][aggregationLen];
        this.newSampleChildren = Lists.newArrayList();
        this.reset();
    }

    public LocalSampleLogger getMetricsData() {
        return this.metricsData;
    }

    public void reset() {
        this.metricsData = new LocalSampleLogger(COLUMN_NUM);
        this.index = 0;
    }

    public void addData(long ms) {
        this.buffer[0][this.index++] = ms;
        if (this.index == this.aggregationLen) {
            this.harvestBuffer();
        }
    }

    public void addDataExtra(long ms, int column) {
        if (1 <= column && column < COLUMN_NUM) {
            this.buffer[column][this.index] = ms;
        }
    }

    public void addNewSampleCallback(MetricsStatistic child) {
        this.newSampleChildren.add(child);
    }

    private void harvestBuffer() {
        int cl;
        long[] samples = new long[COLUMN_NUM];
        for (cl = 0; cl < samples.length; ++cl) {
            samples[cl] = this.aggregationType.process(this.buffer[cl]);
            Arrays.fill(this.buffer[cl], 0L);
        }
        this.index = 0;
        for (cl = 1; cl < COLUMN_NUM; ++cl) {
            this.metricsData.logPartialSample(samples[cl], cl);
        }
        this.metricsData.logSample(samples[0]);
        this.newSampleChildren.forEach(child -> {
            for (int cl = 1; cl < samples.length; ++cl) {
                child.addDataExtra(samples[cl], cl);
            }
            child.addData(samples[0]);
        });
    }

    public static enum Type {
        AVG(s -> (long)s.average().orElse(0.0)),
        MAX(s -> s.max().orElse(0L));

        private final Function<LongStream, Long> harvester;

        private Type(Function<LongStream, Long> harvester) {
            this.harvester = harvester;
        }

        public long process(long[] buffer) {
            return this.harvester.apply(Arrays.stream(buffer));
        }
    }
}

