/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.spectatorTeleportCommand;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.mixins.tweaks.features.spectatorTeleportCommand.EntitySelectorAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class EntitySelectorHack {
    public static UUID getSingleEntityUuid(EntitySelector entitySelector, CommandSourceStack source) throws CommandSyntaxException {
        EntitySelectorAccessor selector = (EntitySelectorAccessor)entitySelector;
        Minecraft mc = Minecraft.getInstance();
        ServerLevel world = source.getLevel();
        ClientPacketListener networkHandler = mc.getConnection();
        if (networkHandler == null) {
            throw EntityArgument.NO_ENTITIES_FOUND.create();
        }
        if (selector.getPlayerName() != null) {
            for (PlayerInfo entry : networkHandler.getOnlinePlayers()) {
                if (!entry.getProfile().getName().equalsIgnoreCase(selector.getPlayerName())) continue;
                return entry.getProfile().getId();
            }
            throw EntityArgument.NO_PLAYERS_FOUND.create();
        }
        if (selector.getUuid() != null) {
            boolean found = false;
            for (Entity entity : world.getEntities().getAll()) {
                if (!entity.getUUID().equals(selector.getUuid())) continue;
                found = true;
                break;
            }
            if (!found) {
                TweakerMoreMod.LOGGER.warn("Entity with uuid '{}' not found in the client world, spectator teleport might fail", (Object)selector.getUuid());
            }
            return selector.getUuid();
        }
        Vec3 pos = selector.getPositionOffset().apply(source.getPosition());
        Predicate<Entity> predicate = selector.invokeGetPositionPredicate(pos, selector.invokeGetOffsetBox(pos), source.getUnsidedLevel().enabledFeatures());
        if (selector.getSenderOnly()) {
            if (source.getEntity() != null && predicate.test(source.getEntity())) {
                return source.getEntity().getUUID();
            }
        } else {
            List<Entity> candidates = EntitySelectorHack.getEntitiesFromWorld(selector, world, pos, predicate);
            if (candidates.size() > 1) {
                selector.getSorter().accept(pos, candidates);
            }
            if (!candidates.isEmpty()) {
                return candidates.getFirst().getUUID();
            }
        }
        throw EntityArgument.NO_ENTITIES_FOUND.create();
    }

    private static List<Entity> getEntitiesFromWorld(EntitySelectorAccessor selector, ServerLevel world, Vec3 pos, Predicate<Entity> predicate) {
        if (selector.getBox() != null) {
            return world.getEntities(Objects.requireNonNull(selector.getEntityFilter()), selector.getBox().move(pos), predicate);
        }
        ArrayList entities = Lists.newArrayList();
        for (Entity entity : world.getEntities().getAll()) {
            if (selector.getEntityFilter() != null && selector.getEntityFilter().tryCast((Object)entity) == null || !predicate.test(entity)) continue;
            entities.add(entity);
        }
        return entities;
    }
}

