/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer;

import com.google.common.collect.Maps;
import fi.dy.masa.malilib.interfaces.IClientTickHandler;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer.DataQueryHandlerPro;
import me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer.EntityMotionStateRestorer;
import me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer.LimitedTaskRunner;
import me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer.TargetPair;
import me.fallenbreath.tweakermore.util.compat.carpettisaddition.CarpetTISAdditionAccess;
import me.fallenbreath.tweakermore.util.event.TweakerMoreEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class ServerDataSyncer
extends LimitedTaskRunner
implements IClientTickHandler {
    private static final ServerDataSyncer INSTANCE = new ServerDataSyncer();
    private final Map<BlockPos, CompletableFuture<CompoundTag>> syncBlockEntityPos = Maps.newHashMap();
    private final Map<Integer, CompletableFuture<CompoundTag>> syncedEntityId = Maps.newHashMap();
    private final DataQueryHandlerPro queryHandler = new DataQueryHandlerPro();

    private ServerDataSyncer() {
        TweakerMoreEvents.registerDimensionChangedCallback(this::onDimensionChanged);
    }

    @Override
    protected int getMaxTaskPerTick() {
        return TweakerMoreConfigs.SERVER_DATA_SYNCER_QUERY_LIMIT.getIntegerValue();
    }

    @Override
    protected int getTaskExecuteCooldown() {
        return TweakerMoreConfigs.SERVER_DATA_SYNCER_QUERY_INTERVAL.getIntegerValue() - 1;
    }

    public static ServerDataSyncer getInstance() {
        return INSTANCE;
    }

    public DataQueryHandlerPro getQueryHandler() {
        return this.queryHandler;
    }

    public static boolean hasEnoughPermission() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && mc.player.hasPermissions(2)) {
            return true;
        }
        return CarpetTISAdditionAccess.getBooleanRule("debugNbtQueryNoPermission").orElse(false);
    }

    public void resetSyncLimiter() {
        this.syncBlockEntityPos.clear();
        this.syncedEntityId.clear();
    }

    public void onClientTick(Minecraft mc) {
        this.resetSyncLimiter();
        this.tickTask();
    }

    public void onDimensionChanged() {
        this.resetSyncLimiter();
        this.queryHandler.clearCallbacks();
    }

    public Optional<CompletableFuture<@Nullable CompoundTag>> fetchEntity(Entity entity) {
        if (ServerDataSyncer.hasEnoughPermission()) {
            return Optional.of(this.syncedEntityId.computeIfAbsent(entity.getId(), entityId -> {
                CompletableFuture future = new CompletableFuture();
                this.runOrEnqueueTask(() -> {
                    TweakerMoreMod.LOGGER.debug("Fetching entity data of {}", (Object)entity);
                    this.queryHandler.queryEntityNbt((int)entityId, future::complete);
                });
                return future;
            }));
        }
        return Optional.empty();
    }

    public Optional<CompletableFuture<@Nullable CompoundTag>> fetchBlockEntity(BlockEntity blockEntity) {
        if (ServerDataSyncer.hasEnoughPermission()) {
            return Optional.of(this.syncBlockEntityPos.computeIfAbsent(blockEntity.getBlockPos(), pos -> {
                CompletableFuture future = new CompletableFuture();
                this.runOrEnqueueTask(() -> {
                    TweakerMoreMod.LOGGER.debug("Syncing block entity data at {}", pos);
                    this.queryHandler.queryBlockNbt(blockEntity.getBlockPos(), future::complete);
                });
                return future;
            }));
        }
        return Optional.empty();
    }

    public CompletableFuture<Void> syncEntity(Entity entity, boolean syncMotionState) {
        Optional<CompletableFuture<CompoundTag>> opt = this.fetchEntity(entity);
        if (opt.isPresent()) {
            return opt.get().thenAccept(nbt -> {
                block5: {
                    if (nbt != null) {
                        EntityMotionStateRestorer restorer = null;
                        if (!syncMotionState) {
                            restorer = new EntityMotionStateRestorer(entity);
                        }
                        try {
                            entity.load(nbt);
                            if (restorer != null) {
                                restorer.restore();
                            }
                            TweakerMoreMod.LOGGER.debug("Synced entity data of {}", (Object)entity);
                        }
                        catch (Exception exception) {
                            TweakerMoreMod.LOGGER.warn("Failed to sync entity data of {}: {}", (Object)entity, (Object)exception);
                            if (!TweakerMoreConfigs.TWEAKERMORE_DEBUG_MODE.getBooleanValue()) break block5;
                            TweakerMoreMod.LOGGER.warn("[TweakerMore Debug] ServerDataSyncer#syncEntity", (Throwable)exception);
                        }
                    }
                }
            });
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public CompletableFuture<Void> syncEntity(Entity entity) {
        return this.syncEntity(entity, true);
    }

    public CompletableFuture<Void> syncBlockEntity(BlockEntity blockEntity) {
        if (ServerDataSyncer.hasEnoughPermission()) {
            Optional<CompletableFuture<CompoundTag>> opt = this.fetchBlockEntity(blockEntity);
            Level world = blockEntity.getLevel();
            if (opt.isPresent() && world != null) {
                return opt.get().thenAccept(nbt -> {
                    block3: {
                        if (nbt != null) {
                            BlockPos pos = blockEntity.getBlockPos();
                            try {
                                blockEntity.loadWithComponents(nbt, (HolderLookup.Provider)blockEntity.getLevel().registryAccess());
                                TweakerMoreMod.LOGGER.debug("Synced block entity data at {}", (Object)pos);
                            }
                            catch (Exception exception) {
                                TweakerMoreMod.LOGGER.warn("Failed to sync block entity data at {}: {}", (Object)pos, (Object)exception);
                                if (!TweakerMoreConfigs.TWEAKERMORE_DEBUG_MODE.getBooleanValue()) break block3;
                                TweakerMoreMod.LOGGER.warn("[TweakerMore Debug] ServerDataSyncer#syncBlockEntity", (Throwable)exception);
                            }
                        }
                    }
                });
            }
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public CompletableFuture<Void> syncBlockEntityAt(BlockPos pos) {
        Level world;
        BlockEntity blockEntity;
        Minecraft mc = Minecraft.getInstance();
        if (ServerDataSyncer.hasEnoughPermission() && mc.player != null && (blockEntity = (world = mc.player.level()).getBlockEntity(pos)) != null && pos.equals((Object)blockEntity.getBlockPos())) {
            return this.syncBlockEntity(blockEntity);
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public CompletableFuture<Void> syncBlockInventory(Container inventory) {
        if (inventory instanceof BlockEntity) {
            return this.syncBlockEntity((BlockEntity)inventory);
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public CompletableFuture<Void> syncEverything(TargetPair pair, ProgressCallback callback) {
        AtomicInteger beCounter = new AtomicInteger(0);
        AtomicInteger entityCounter = new AtomicInteger(0);
        CompletableFuture<Void> beSynced = CompletableFuture.allOf((CompletableFuture[])pair.getBlockEntityPositions().stream().map(this::syncBlockEntityAt).map(f -> f.thenRun(() -> callback.apply(beCounter.addAndGet(1), entityCounter.get()))).toArray(CompletableFuture[]::new));
        CompletableFuture<Void> entitySynced = CompletableFuture.allOf((CompletableFuture[])pair.getEntities().stream().map(this::syncEntity).map(f -> f.thenRun(() -> callback.apply(beCounter.get(), entityCounter.addAndGet(1)))).toArray(CompletableFuture[]::new));
        return CompletableFuture.allOf(beSynced, entitySynced);
    }

    @FunctionalInterface
    public static interface ProgressCallback {
        public void apply(int var1, int var2);
    }
}

