/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.mixins.tweaks.mc_tweaks.disableSignTextLengthLimit;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Restriction(conflict={@Condition(value="caxton", versionPredicates={"(, 0.3.0-beta.2)"})})
@Mixin(value={AbstractSignEditScreen.class})
public abstract class SignEditScreenMixin
extends Screen {
    @Shadow
    @Final
    protected SignBlockEntity sign;
    @Shadow
    private SignText text;
    @Shadow
    @Final
    private String[] messages;
    @Unique
    private boolean filtered$TKM;

    protected SignEditScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/block/entity/SignBlockEntity;ZZLnet/minecraft/network/chat/Component;)V"}, at={@At(value="TAIL")})
    private void recordFilteredParam(SignBlockEntity sign, boolean front, boolean filtered, Component title, CallbackInfo ci) {
        this.filtered$TKM = filtered;
    }

    @ModifyExpressionValue(method={"lambda$init$4"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/SignBlockEntity;getMaxTextLineWidth()I", remap=true)}, remap=false)
    private int disableSignTextLengthLimitInSignEditor(int maxLength) {
        if (TweakerMoreConfigs.DISABLE_SIGN_TEXT_LENGTH_LIMIT.getBooleanValue()) {
            maxLength = Integer.MAX_VALUE;
        }
        return maxLength;
    }

    @Inject(method={"renderSignText"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)I", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void drawLineOverflowHint(GuiGraphics context, CallbackInfo ci, @Local(ordinal=5) int lineIdx, @Local(ordinal=6) int xStart) {
        if (TweakerMoreConfigs.DISABLE_SIGN_TEXT_LENGTH_LIMIT.getBooleanValue()) {
            int textArrayLen = this.messages.length;
            Minecraft mc = this.minecraft;
            if (mc != null && 0 <= lineIdx && lineIdx < textArrayLen) {
                boolean overflowed;
                int maxWidth;
                Component text = this.text.getMessage(lineIdx, this.filtered$TKM);
                List wrapped = mc.font.split((FormattedText)text, maxWidth = this.sign.getMaxTextLineWidth());
                boolean bl = overflowed = wrapped.size() > 1;
                if (overflowed) {
                    assert (ChatFormatting.RED.getColor() != null);
                    int lineHeight = this.sign.getTextLineHeight();
                    int x = xStart - 10;
                    int y = lineIdx * lineHeight - 4 * lineHeight / 2;
                    context.drawString(this.font, "!", x, y, ChatFormatting.RED.getColor().intValue(), false);
                }
            }
        }
    }
}

