/*
 * Decompiled with CFR 0.152.
 */
package com.github.darkpred.morehitboxes.internal;

import com.github.darkpred.morehitboxes.api.HitboxData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class HitboxDataLoader
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static final HitboxDataLoader HITBOX_DATA = new HitboxDataLoader(GSON);
    private ImmutableMap<class_2960, List<HitboxData>> hitboxData = ImmutableMap.of();

    public HitboxDataLoader(Gson gson) {
        super(gson, "hitboxes");
    }

    public List<HitboxData> getHitboxes(class_2960 entityLocation) {
        return (List)this.hitboxData.get((Object)entityLocation);
    }

    public Map<class_2960, List<HitboxData>> getHitboxData() {
        return this.hitboxData;
    }

    protected void apply(Map<class_2960, JsonElement> jsons, @NotNull class_3300 resourceManager, @NotNull class_3695 profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<class_2960, JsonElement> fileEntry : jsons.entrySet()) {
            JsonElement jsonElement = fileEntry.getValue();
            if (!(jsonElement instanceof JsonObject)) continue;
            JsonObject root = (JsonObject)jsonElement;
            JsonArray elements = class_3518.method_15261((JsonObject)root, (String)"elements");
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (JsonElement element : elements) {
                JsonObject elemObject = element.getAsJsonObject();
                double[] pos = new double[3];
                JsonArray posArray = class_3518.method_15261((JsonObject)elemObject, (String)"pos");
                JsonElement refElement = elemObject.get("ref");
                String ref = refElement == null ? "" : refElement.getAsString();
                for (int i = 0; i < pos.length; ++i) {
                    pos[i] = class_3518.method_34922((JsonElement)posArray.get(i), (String)("pos[" + i + "]"));
                }
                if (elemObject.has("is_anchor") && class_3518.method_15270((JsonObject)elemObject, (String)"is_anchor")) {
                    listBuilder.add((Object)new HitboxData(elemObject.get("name").getAsString(), new class_243(pos[0] / 16.0, pos[1] / 16.0, pos[2] / 16.0), 0.0f, 0.0f, ref, false, true));
                    continue;
                }
                float width = class_3518.method_15259((JsonObject)elemObject, (String)"width") / 16.0f;
                float height = class_3518.method_15259((JsonObject)elemObject, (String)"height") / 16.0f;
                JsonElement attackElement = elemObject.get("is_attack_box");
                boolean isAttack = attackElement != null && attackElement.getAsBoolean();
                listBuilder.add((Object)new HitboxData(elemObject.get("name").getAsString(), new class_243(pos[0] / 16.0, pos[1] / 16.0, pos[2] / 16.0), width, height, ref, isAttack, false));
            }
            builder.put((Object)fileEntry.getKey(), (Object)listBuilder.build());
        }
        this.hitboxData = builder.build();
    }

    public void replaceData(Map<class_2960, List<HitboxData>> dataMap) {
        this.hitboxData = ImmutableMap.copyOf(dataMap);
    }

    public static List<HitboxData> readBuf(class_2540 buf) {
        return buf.method_34066(HitboxData::readBuf);
    }

    private static void writeBuf(class_2540 buf, List<HitboxData> hitboxes) {
        buf.method_34062(hitboxes, HitboxData::writeBuf);
    }

    public void writeBuf(class_2540 buf) {
        buf.method_34063(this.hitboxData, (buffer, key) -> buf.method_10812(key), HitboxDataLoader::writeBuf);
    }
}

