/*
 * Decompiled with CFR 0.152.
 */
package com.github.darkpred.morehitboxes.internal;

import com.github.darkpred.morehitboxes.api.AnchorData;
import com.github.darkpred.morehitboxes.api.HitboxData;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1308;
import net.minecraft.class_243;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class AnchorDataInternal<T extends class_1308>
implements AnchorData {
    private final Map<String, HitboxData> anchors = new Object2ObjectOpenHashMap();
    private final Set<String> anchorOverride = new ObjectArraySet();
    private final Map<HitboxData, class_243> anchorPositions = new Object2ObjectOpenHashMap();
    private final Map<HitboxData, class_243> anchorPositionBackup = new Object2ObjectOpenHashMap();
    private final T entity;

    public AnchorDataInternal(T entity) {
        this.entity = entity;
    }

    @Override
    public Optional<class_243> getAnchorPos(String ref) {
        return Optional.ofNullable(this.anchorPositions.get(this.anchors.get(ref)));
    }

    @Override
    public boolean isAnchor(String ref) {
        return this.anchors.containsKey(ref);
    }

    @Override
    public void addAnchor(String ref, HitboxData hitboxData) {
        this.anchors.put(ref, hitboxData);
    }

    @Override
    public void updatePositions() {
        for (Map.Entry<String, HitboxData> entry : this.anchors.entrySet()) {
            if (this.anchorOverride.contains(entry.getKey())) {
                this.anchorOverride.remove(entry.getKey());
                continue;
            }
            class_243 offset = entry.getValue().pos();
            class_243 newPos = this.entity.method_19538().method_1019(new class_243(offset.field_1352, offset.field_1351, offset.field_1350).method_1024(-((class_1308)this.entity).field_6283 * ((float)Math.PI / 180)).method_1021((double)this.entity.method_55693()));
            this.anchorPositions.put(entry.getValue(), newPos);
        }
    }

    @Override
    public void updatePosition(String ref, class_243 localPos) {
        HitboxData hitbox = this.anchors.get(ref);
        class_243 prevActual = this.anchorPositionBackup.get(hitbox);
        class_243 pos = this.entity.method_19538().method_1019(localPos);
        this.anchorPositionBackup.put(hitbox, pos);
        if (prevActual != null) {
            pos = prevActual.method_1020(this.anchorPositions.get(hitbox)).method_1033() > 0.05 ? pos.method_1019(pos.method_1020(prevActual).method_1021(0.5)) : pos.method_1019(pos.method_1020(prevActual));
        }
        this.anchorPositions.put(hitbox, pos);
        this.anchorOverride.add(ref);
    }
}

