/*
 * Decompiled with CFR 0.152.
 */
package com.github.darkpred.morehitboxes.internal;

import com.github.darkpred.morehitboxes.api.AttackBoxData;
import com.github.darkpred.morehitboxes.api.HitboxData;
import com.github.darkpred.morehitboxes.api.MultiPartEntity;
import com.github.darkpred.morehitboxes.platform.Services;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4048;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class AttackBoxDataInternal<T extends class_1308>
implements AttackBoxData {
    private final Map<String, HitboxData> attackBoxes = new Object2ObjectOpenHashMap();
    private final Map<HitboxData, class_243> activeAttackBoxes = new Object2ObjectOpenHashMap();
    private long attackBoxEndTime;
    private final T entity;

    public AttackBoxDataInternal(T entity) {
        this.entity = entity;
    }

    @Override
    public void addAttackBox(String ref, HitboxData hitboxData) {
        this.attackBoxes.put(ref, hitboxData);
    }

    @Override
    public HitboxData getAttackBox(String ref) {
        return this.attackBoxes.get(ref);
    }

    @Override
    public void moveActiveAttackBox(HitboxData attackBox, class_243 worldPos) {
        this.activeAttackBoxes.put(attackBox, worldPos);
    }

    @Override
    public boolean isAttackBoxActive(HitboxData attackBox) {
        return this.activeAttackBoxes.containsKey(attackBox);
    }

    @Override
    public void activateAttackBoxes(class_1937 level, double attackDuration) {
        this.attackBoxes.values().forEach(hitbox -> this.activeAttackBoxes.put((HitboxData)hitbox, class_243.field_1353));
        this.attackBoxEndTime = (long)((double)level.method_8510() + attackDuration);
    }

    @Override
    public void clientTick(class_1937 level) {
        if (level.method_8510() > this.attackBoxEndTime) {
            this.activeAttackBoxes.clear();
        }
        for (Map.Entry<HitboxData, class_243> entry : this.activeAttackBoxes.entrySet()) {
            HitboxData hitbox = entry.getKey();
            class_4048 size = class_4048.method_18384((float)hitbox.width(), (float)hitbox.height()).method_18383(this.entity.method_55693());
            class_238 aabb = size.method_30757(entry.getValue());
            class_1657 player = DistUtilFactory.DIST_UTIL.handleIntersect(aabb);
            if (player == null) continue;
            if (!((MultiPartEntity)this.entity).attackBoxHit(player)) break;
            this.activeAttackBoxes.clear();
            break;
        }
    }

    @Override
    public Map<HitboxData, class_243> getActiveBoxes() {
        return this.activeAttackBoxes;
    }

    @Override
    public long attackBoxEndTime() {
        return this.attackBoxEndTime;
    }

    @ApiStatus.Internal
    public static interface DistUtilFactory {
        public static final DistUtilFactory DIST_UTIL = Services.load(DistUtilFactory.class);

        public class_1657 handleIntersect(class_238 var1);
    }
}

