/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.client;

import com.folumo.isthisindustry.common.misc.transporters.CableNetworkManager;
import com.folumo.isthisindustry.common.payload.research.ServerPayloadHandler_research;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="isthisindustry", value={Dist.CLIENT})
public class NeoForgeEvents {
    @SubscribeEvent
    public static void onAdvancementCompleted(AdvancementEvent.AdvancementEarnEvent event) {
        NeoForgeEvents.onAdvancement((AdvancementEvent)event);
    }

    @SubscribeEvent
    public static void onAdvancementCompleted(AdvancementEvent.AdvancementProgressEvent event) {
        NeoForgeEvents.onAdvancement((AdvancementEvent)event);
    }

    private static void onAdvancement(AdvancementEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ResourceLocation advancementId = event.getAdvancement().id();
        if (!advancementId.getNamespace().equals("isthisindustry")) {
            return;
        }
        ServerPayloadHandler_research.handleResearchSync(serverPlayer);
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerPayloadHandler_research.handleResearchSync(serverPlayer);
    }

    @SubscribeEvent
    public static void preServerTick(ServerTickEvent.Pre event) {
        MinecraftServer mc = event.getServer();
        Set levels = mc.levelKeys();
        for (ResourceKey levelResourceKey : levels) {
            ServerLevel level = mc.getLevel(levelResourceKey);
            CableNetworkManager.tick((Level)level);
        }
    }
}

