/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.client.screen;

import com.folumo.isthisindustry.Isthisindustry;
import com.folumo.isthisindustry.common.containers.BlueprintContainer;
import com.folumo.isthisindustry.common.misc.research.Research;
import com.folumo.isthisindustry.common.network.UpdateBlueprintTypePayload;
import com.folumo.isthisindustry.common.payload.research.ResearchDataClient_research;
import com.folumo.isthisindustry.common.reg.ResearchReg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class BlueprintScreen
extends AbstractContainerScreen<BlueprintContainer> {
    private static final ResourceLocation BACKGROUND = Isthisindustry.resource("textures/gui/blueprint/bg.png");
    private static final ResourceLocation CONTAINER = Isthisindustry.resource("textures/gui/research_station/container.png");
    private static final ResourceLocation INDICATOR = Isthisindustry.resource("textures/gui/research_station/indicator.png");
    private int scrollOffset = 0;
    private static final int MAX_VISIBLE_RESEARCHES = 6;

    public BlueprintScreen(BlueprintContainer container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.imageWidth = 256;
        this.imageHeight = 256;
        this.titleLabelX = 146;
        this.titleLabelY = 52;
        this.inventoryLabelX = 48;
        this.inventoryLabelY = 120;
    }

    private Map<Research, Boolean> onlyUnlocked(List<Research> researchList, Set<String> unlocked) {
        HashMap<Research, Boolean> map = new HashMap<Research, Boolean>();
        for (Research research : researchList) {
            if (!research.isMachine()) continue;
            boolean isUnlocked = unlocked.contains(research.id().toString());
            map.put(research, isUnlocked);
        }
        return map;
    }

    private Component getTr(Research research) {
        return Component.translatable((String)("title." + research.id().getNamespace() + "." + research.id().getPath().replace("/", ".")));
    }

    private Component getError(String name) {
        return Component.translatable((String)("error.isthisindustry.blueprint." + name));
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float p_281886_) {
        super.render(guiGraphics, mouseX, mouseY, p_281886_);
        int x = this.leftPos + 45;
        AtomicInteger y = new AtomicInteger(this.topPos + 50 + this.scrollOffset);
        Map<Research, Boolean> data = this.onlyUnlocked(ResearchReg.researches, ResearchDataClient_research.INSTANCE.getResearches());
        data.forEach((research, isUnlocked) -> {
            guiGraphics.blit(CONTAINER, x, y.get(), 0.0f, 0.0f, 81, 22, 81, 22);
            int u = 4;
            if (isUnlocked.booleanValue()) {
                u = 0;
            }
            guiGraphics.blit(INDICATOR, x + 73, y.get() + 4, (float)u, 0.0f, 4, 4, 8, 4);
            if (mouseX >= x && mouseX <= x + 81 && mouseY >= y.get() && mouseY <= y.get() + 22) {
                guiGraphics.renderTooltip(this.font, this.getTr((Research)research), mouseX, mouseY);
            }
            Item item = (Item)BuiltInRegistries.ITEM.get(research.icon());
            ItemStack stack = new ItemStack((ItemLike)item);
            guiGraphics.renderItem(stack, x + 4, y.get() + 3);
            y.addAndGet(26);
        });
        super.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float p_97788_, int p_97789_, int p_97790_) {
        guiGraphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, 256, 256);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int p_282681_, int p_283686_) {
        super.renderLabels(guiGraphics, p_282681_, p_283686_);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double p_94688_, double p_294830_) {
        int total = this.onlyUnlocked(ResearchReg.researches, ResearchDataClient_research.INSTANCE.getResearches()).size();
        int maxOffset = Math.max(0, total - 6);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset - (int)Math.signum(p_94688_), maxOffset));
        return true;
    }

    private List<Research> visibleResearches() {
        ArrayList<Research> fullList = new ArrayList<Research>(this.onlyUnlocked(ResearchReg.researches, ResearchDataClient_research.INSTANCE.getResearches()).keySet());
        int end = Math.min(this.scrollOffset + 6, fullList.size());
        return fullList.subList(this.scrollOffset, end);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int x = this.leftPos + 45;
        int y = this.topPos + 50;
        List<Research> visible = this.visibleResearches();
        for (int i = 0; i < visible.size(); ++i) {
            int yOffset = y + i * 26;
            if (!(mouseX >= (double)x) || !(mouseX <= (double)(x + 81)) || !(mouseY >= (double)yOffset) || !(mouseY <= (double)(yOffset + 22))) continue;
            Research clicked = visible.get(i);
            boolean isUnlocked = ResearchDataClient_research.INSTANCE.getResearches().contains(clicked.id().toString());
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return true;
            }
            if (isUnlocked) {
                player.displayClientMessage(this.getError("set_research"), true);
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateBlueprintTypePayload(clicked.target().toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                player.displayClientMessage(this.getError("missing_research"), true);
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateBlueprintTypePayload("null"), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

