/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.client.screen;

import com.folumo.isthisindustry.Isthisindustry;
import com.folumo.isthisindustry.common.blockEntity.HologramBlockEntity;
import com.folumo.isthisindustry.common.containers.HologramContainer;
import com.folumo.isthisindustry.common.inerfaces.IBlueprint;
import com.folumo.isthisindustry.common.network.RequestBuildHologramPayload;
import com.folumo.tomatolib.client.gui.elements.GUIButton;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class HologramScreen
extends AbstractContainerScreen<HologramContainer> {
    private static final ResourceLocation BACKGROUND = Isthisindustry.resource("textures/gui/hologram/bg.png");
    private static final ResourceLocation HAMMER = Isthisindustry.resource("textures/gui/hologram/hammer.png");
    private HologramBlockEntity blockEntity;
    private GUIButton buildButton;

    public HologramScreen(HologramContainer container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        BlockEntity be;
        this.imageWidth = 256;
        this.imageHeight = 256;
        this.titleLabelX = 48;
        this.titleLabelY = 50;
        this.inventoryLabelX = 48;
        this.inventoryLabelY = 120;
        if (Minecraft.getInstance().level != null && (be = Minecraft.getInstance().level.getBlockEntity(container.pos)) != null) {
            this.blockEntity = (HologramBlockEntity)be;
        }
    }

    protected void init() {
        super.init();
        this.buildButton = new GUIButton(this, this.leftPos + 211 - 16, this.topPos + 51, 16, 16, HAMMER){

            public void renderOnHover(@NotNull GuiGraphics guiGraphics, @NotNull Font font, int x, int y) {
                super.renderOnHover(guiGraphics, font, x, y);
                MutableComponent text = Component.translatable((String)"title.isthisindustry.hologram.build");
                guiGraphics.renderTooltip(font, (Component)text, x, y);
            }
        };
        this.buildButton.setOnClick(this::tryAndBuild);
    }

    private void tryAndBuild() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)this.blockEntity.getTargetBlock()));
        IBlueprint blueprint = (IBlueprint)block;
        for (ItemStack cost : blueprint.blueprintCost()) {
            int owned = 0;
            for (ItemStack stack : player.getInventory().items) {
                if (stack.getItem() != cost.getItem()) continue;
                owned += stack.getCount();
            }
            if (owned >= cost.getCount()) continue;
            player.displayClientMessage(this.getError("missing_items"), true);
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new RequestBuildHologramPayload(this.blockEntity.getOriginBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int x, int y, float p_281886_) {
        super.render(guiGraphics, x, y, p_281886_);
        if (this.blockEntity != null) {
            this.buildButton.render(guiGraphics);
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)this.blockEntity.getTargetBlock()));
            if (block instanceof IBlueprint) {
                IBlueprint blueprint = (IBlueprint)block;
                int X = this.leftPos + 45;
                int Y = this.topPos + 60;
                for (ItemStack itemStack : blueprint.blueprintCost()) {
                    MutableComponent text = (MutableComponent)itemStack.getDisplayName();
                    text.append(": " + itemStack.getCount());
                    guiGraphics.drawString(this.font, (Component)text, X, Y, 0x404040, false);
                    Objects.requireNonNull(this.font);
                    Y += 9;
                }
            }
            if (this.buildButton.tryCollision(x, y)) {
                this.buildButton.renderOnHover(guiGraphics, this.font, x, y);
            }
        }
        super.renderTooltip(guiGraphics, x, y);
    }

    protected void renderBg(GuiGraphics guiGraphics, float p_97788_, int p_97789_, int p_97790_) {
        guiGraphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, 256, 256);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int p_282681_, int p_283686_) {
        super.renderLabels(guiGraphics, p_282681_, p_283686_);
    }

    private Component getError(String name) {
        return Component.translatable((String)("error.isthisindustry.hologram." + name));
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.buildButton.tryCollision((int)x, (int)y)) {
            this.buildButton.onActivate();
            return true;
        }
        return super.mouseClicked(x, y, button);
    }
}

