/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.client.screen;

import com.folumo.isthisindustry.Isthisindustry;
import com.folumo.isthisindustry.common.containers.ResearchStationContainer;
import com.folumo.isthisindustry.common.misc.research.Research;
import com.folumo.isthisindustry.common.misc.research.ResourceLocationIntPair;
import com.folumo.isthisindustry.common.network.RequestGrantAdvancementPayload;
import com.folumo.isthisindustry.common.payload.research.ResearchDataClient_research;
import com.folumo.isthisindustry.common.reg.ResearchReg;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class ResearchStationScreen
extends AbstractContainerScreen<ResearchStationContainer> {
    private static final ResourceLocation BACKGROUND = Isthisindustry.resource("textures/gui/research_station/bg.png");
    private static final ResourceLocation CONTAINER = Isthisindustry.resource("textures/gui/research_station/container.png");
    private static final ResourceLocation INDICATOR = Isthisindustry.resource("textures/gui/research_station/indicator.png");
    private static final ResourceLocation LOCK = Isthisindustry.resource("textures/gui/research_station/lock.png");
    private float scrollOffset = 0.0f;
    private static final int ENTRY_HEIGHT = 26;
    private static final int MAX_VISIBLE_RESEARCHES = 3;
    private static Research viewingResearch;

    public ResearchStationScreen(ResearchStationContainer container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.imageWidth = 256;
        this.imageHeight = 256;
        this.titleLabelX = 51;
        this.titleLabelY = 37;
        this.inventoryLabelX = 48;
        this.inventoryLabelY = 120;
        viewingResearch = ResearchReg.researches.getFirst();
    }

    private Map<Research, Boolean> onlyUnlocked(List<Research> researchList, Set<String> unlocked) {
        LinkedHashMap<Research, Boolean> map = new LinkedHashMap<Research, Boolean>();
        for (Research research : researchList) {
            boolean isUnlocked = unlocked.contains(research.id().toString());
            map.put(research, isUnlocked);
        }
        return map;
    }

    private MutableComponent getTr(Research research) {
        return Component.translatable((String)("title." + research.id().getNamespace() + "." + research.id().getPath().replace("/", ".")));
    }

    private MutableComponent getTr(ResourceLocation location) {
        String namespace = location.getNamespace();
        String path = location.getPath().replace("/", ".");
        String itemKey = "item." + namespace + "." + path;
        String blockKey = "block." + namespace + "." + path;
        if (I18n.exists((String)itemKey)) {
            return Component.translatable((String)itemKey);
        }
        if (I18n.exists((String)blockKey)) {
            return Component.translatable((String)blockKey);
        }
        return Component.literal((String)location.toString());
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int x = this.leftPos + 45;
        int yStart = this.topPos + 50;
        int yClippingEnd = this.topPos + 117;
        guiGraphics.enableScissor(this.leftPos, yStart, this.leftPos + this.imageWidth, yClippingEnd);
        Map<Research, Boolean> data = this.onlyUnlocked(ResearchReg.researches, ResearchDataClient_research.INSTANCE.getResearches());
        ArrayList<Map.Entry<Research, Boolean>> researchList = new ArrayList<Map.Entry<Research, Boolean>>(data.entrySet());
        for (int i = 0; i < researchList.size(); ++i) {
            int y = yStart + i * 26 - (int)this.scrollOffset;
            if (y + 26 < yStart || y > yClippingEnd) continue;
            Research research = (Research)((Map.Entry)researchList.get(i)).getKey();
            boolean isUnlocked = (Boolean)((Map.Entry)researchList.get(i)).getValue();
            guiGraphics.blit(CONTAINER, x, y, 0.0f, 0.0f, 81, 22, 81, 22);
            int u = isUnlocked ? 0 : 4;
            guiGraphics.blit(INDICATOR, x + 73, y + 4, (float)u, 0.0f, 4, 4, 8, 4);
            if (mouseX >= x && mouseX <= x + 81 && mouseY >= y && mouseY <= y + 22) {
                guiGraphics.renderTooltip(this.font, (Component)this.getTr(research), mouseX, mouseY);
            }
            ItemStack iconStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(research.icon()));
            guiGraphics.renderItem(iconStack, x + 4, y + 3);
        }
        guiGraphics.disableScissor();
        if (viewingResearch != null) {
            int W = 80;
            int START_X = this.leftPos + 133;
            int START_Y = this.topPos + 50;
            MutableComponent name = this.getTr(viewingResearch);
            int nameX = START_X + (W - this.font.width((FormattedText)name)) / 2;
            guiGraphics.drawString(this.font, (Component)name, nameX, START_Y, 0x404040, false);
            Objects.requireNonNull(this.font);
            int lockX = START_X + (W - 18) / 2;
            guiGraphics.blit(LOCK, lockX, START_Y += 9 + 2, 0.0f, 0.0f, 18, 18, 18, 18);
            if (mouseX >= lockX && mouseX <= lockX + 18 && mouseY >= START_Y && mouseY <= START_Y + 18) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"title.isthisindustry.research.research"), mouseX, mouseY);
            }
            START_Y += 20;
            int textX = START_X + 4;
            for (ResourceLocationIntPair pair : viewingResearch.cost()) {
                MutableComponent text = this.getTr(pair.resourceLocation()).append(": " + pair.num());
                guiGraphics.drawString(this.font, (Component)text, textX, START_Y, 0x404040, false);
                Objects.requireNonNull(this.font);
                START_Y += 9;
            }
        }
        super.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, 256, 256);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int totalEntries = this.onlyUnlocked(ResearchReg.researches, ResearchDataClient_research.INSTANCE.getResearches()).size();
        int totalHeight = totalEntries * 26;
        int maxOffset = Math.max(0, totalHeight - 78);
        this.scrollOffset = (float)Math.max(0.0, Math.min((double)this.scrollOffset - scrollY * 26.0, (double)maxOffset));
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int x = this.leftPos + 45;
        int yStart = this.topPos + 50;
        Map<Research, Boolean> data = this.onlyUnlocked(ResearchReg.researches, ResearchDataClient_research.INSTANCE.getResearches());
        ArrayList<Research> list = new ArrayList<Research>(data.keySet());
        for (int i = 0; i < list.size(); ++i) {
            int y = yStart + i * 26 - (int)this.scrollOffset;
            if (!(mouseX >= (double)x) || !(mouseX <= (double)(x + 81)) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + 22))) continue;
            viewingResearch = (Research)list.get(i);
            return true;
        }
        if (viewingResearch != null) {
            int W = 80;
            int startX = this.leftPos + 133;
            Objects.requireNonNull(this.font);
            int startY = this.topPos + 50 + 9 + 2;
            int lockX = startX + (W - 18) / 2;
            if (mouseX >= (double)lockX && mouseX <= (double)(lockX + 18) && mouseY >= (double)startY && mouseY <= (double)(startY + 18)) {
                this.unlockResearch(viewingResearch);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private Component getError(String name) {
        return Component.translatable((String)("error.isthisindustry.research_station." + name));
    }

    private void unlockResearch(Research research) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (ResearchDataClient_research.INSTANCE.getResearches().contains(research.id().toString())) {
            player.displayClientMessage(this.getError("had_research"), true);
            return;
        }
        if (!ResearchDataClient_research.INSTANCE.getResearches().containsAll(research.criteria())) {
            ResearchDataClient_research.INSTANCE.getResearches().forEach(System.out::println);
            player.displayClientMessage(this.getError("missing_prerequisites"), true);
            return;
        }
        for (ResourceLocationIntPair cost : research.cost()) {
            Item requiredItem = (Item)BuiltInRegistries.ITEM.get(cost.resourceLocation());
            int requiredCount = cost.num();
            int owned = 0;
            for (ItemStack stack : player.getInventory().items) {
                if (stack.getItem() != requiredItem) continue;
                owned += stack.getCount();
            }
            if (owned >= requiredCount) continue;
            player.displayClientMessage(this.getError("missing_items"), true);
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new RequestGrantAdvancementPayload(research.id().toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

