/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.client.screen.elements.tabs;

import com.folumo.isthisindustry.Isthisindustry;
import com.folumo.isthisindustry.common.blockEntity.ElectricBE;
import com.folumo.tomatolib.client.gui.BetterScreen;
import com.folumo.tomatolib.client.gui.elements.GUITab;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class EnergyTab<T extends BetterScreen<?>>
extends GUITab<T> {
    public EnergyTab() {
        super(0, 0, 16, 16, Isthisindustry.resource("textures/gui/tabs/energy.png"));
    }

    public void renderOnHover(@NotNull GuiGraphics guiGraphics, @NotNull Font font, int x, int y) {
        super.renderOnHover(guiGraphics, font, x, y);
        ClientLevel level = Minecraft.getInstance().level;
        assert (level != null);
        BlockEntity blockEntity = level.getBlockEntity(this.screen.pos);
        int energyAmount = 0;
        int maxEnergyAmount = 0;
        if (blockEntity instanceof ElectricBE) {
            ElectricBE electricBE = (ElectricBE)blockEntity;
            energyAmount = electricBE.getEnergyStored();
            maxEnergyAmount = electricBE.getMaxEnergyStored();
        }
        guiGraphics.renderTooltip(font, (Component)Component.literal((String)(energyAmount + "FE / " + maxEnergyAmount + "FE")), x, y);
    }
}

