/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.blockEntity;

import com.folumo.isthisindustry.common.blockEntity.ContainerBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public abstract class ElectricBE
extends ContainerBE
implements IEnergyStorage {
    protected int energy = 0;
    protected int maxEnergy = 0;
    protected boolean canExtract = true;
    protected boolean canInsert = true;

    public ElectricBE(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState, NonNullList<ItemStack> items, int dataSize) {
        super(blockEntityType, blockPos, blockState, items, dataSize);
        this.initialisePower(1000, 0, false, true);
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("EnergyData", (Tag)this.toNBT_energy());
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("EnergyData")) {
            this.fromNBT_energy(tag.getCompound("EnergyData"));
        }
    }

    public int receiveEnergy(int toReceive, boolean simulate) {
        if (!this.canInsert || toReceive <= 0) {
            return 0;
        }
        long spaceLeft = this.maxEnergy - this.energy;
        int accepted = (int)Math.min(spaceLeft, (long)toReceive);
        if (!simulate) {
            this.energy += accepted;
        }
        return accepted;
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        if (!this.canExtract || toExtract <= 0) {
            return 0;
        }
        int extracted = Math.min(this.energy, toExtract);
        if (!simulate) {
            this.energy -= extracted;
        }
        return extracted;
    }

    public void initialisePower(int maxEnergy, int energyAmount) {
        this.initialisePower(maxEnergy, energyAmount, true, true);
    }

    public void initialisePower(int maxEnergyNew, int energyAmountNew, boolean canExtractNew, boolean canInsertNew) {
        this.energy = energyAmountNew;
        this.maxEnergy = maxEnergyNew;
        this.canExtract = canExtractNew;
        this.canInsert = canInsertNew;
    }

    public void setEnergy(int energyNew) {
        this.energy = Math.min(energyNew, this.maxEnergy);
    }

    public void setMaxEnergy(int maxEnergyNew) {
        this.maxEnergy = maxEnergyNew;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.maxEnergy;
    }

    public boolean canExtract() {
        return this.canExtract;
    }

    public boolean canReceive() {
        return this.canInsert;
    }

    public boolean isFull() {
        return this.energy >= this.maxEnergy;
    }

    @Override
    public boolean isEmpty() {
        return (long)this.energy <= 0L;
    }

    @NotNull
    public CompoundTag toNBT_energy() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("Energy", this.energy);
        tag.putInt("MaxEnergy", this.maxEnergy);
        tag.putBoolean("CanExtract", this.canExtract);
        tag.putBoolean("CanInsert", this.canInsert);
        return tag;
    }

    public void fromNBT_energy(CompoundTag tag) {
        this.energy = tag.getInt("Energy");
        this.maxEnergy = tag.getInt("MaxEnergy");
        this.canExtract = tag.getBoolean("CanExtract");
        this.canInsert = tag.getBoolean("CanInsert");
    }

    public void serverTick(Level level, BlockPos blockPos, BlockState blockState) {
    }
}

