/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.blockEntity;

import com.folumo.isthisindustry.common.blockEntity.ContainerBE;
import com.folumo.isthisindustry.common.containers.FirePlaceContainer;
import com.folumo.isthisindustry.common.recipes.FirePlaceRecipe;
import com.folumo.isthisindustry.common.reg.BlockEntityReg;
import com.folumo.isthisindustry.common.reg.RecipeSerializerReg;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirePlaceBlockEntity
extends ContainerBE {
    public FirePlaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityReg.FIRE_PLACE.blockEntity.get(), pos, state, (NonNullList<ItemStack>)NonNullList.withSize((int)2, (Object)ItemStack.EMPTY), 1);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"container.isthisindustry.fire_place");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory inventory, @NotNull Player player) {
        return new FirePlaceContainer(windowId, inventory, this, this.dataAccess);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, FirePlaceBlockEntity blockEntity) {
        if (blockEntity instanceof FirePlaceBlockEntity) {
            FirePlaceBlockEntity be = blockEntity;
            ItemStack inputStack = (ItemStack)be.items.get(0);
            ItemStack outputStack = (ItemStack)be.items.get(1);
            CraftingInput input = CraftingInput.of((int)0, (int)0, Collections.singletonList(inputStack));
            Optional recipe = level.getRecipeManager().getRecipeFor((RecipeType)RecipeSerializerReg.FIRE_PLACE_TYPE.get(), (RecipeInput)input, level);
            if (recipe.isPresent()) {
                ItemStack result = ((FirePlaceRecipe)((RecipeHolder)recipe.get()).value()).assemble(input, (HolderLookup.Provider)level.registryAccess());
                if (outputStack.isEmpty() || ItemStack.isSameItem((ItemStack)outputStack, (ItemStack)result) && outputStack.getCount() + result.getCount() <= outputStack.getMaxStackSize()) {
                    be.items.set(1, (Object)result.copy());
                }
            } else {
                be.items.set(1, (Object)ItemStack.EMPTY);
            }
        }
    }
}

