/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.blockEntity;

import com.folumo.isthisindustry.common.containers.HologramContainer;
import com.folumo.isthisindustry.common.reg.BlockEntityReg;
import com.folumo.tomatolib.common.blockentity.ExtendedBE;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.IContainerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HologramBlockEntity
extends ExtendedBE
implements IContainerFactory<HologramContainer>,
MenuProvider {
    private BlockPos originPosition;
    private String targetBlueprintBlock;

    public HologramBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityReg.HOLOGRAM.blockEntity.get(), pos, state);
    }

    public void setData(BlockPos originPosition, String targetBlueprintBlock) {
        this.originPosition = originPosition;
        this.targetBlueprintBlock = targetBlueprintBlock;
        this.setChanged();
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        if (this.originPosition == null) {
            this.originPosition = new BlockPos(0, 0, 0);
        }
        if (this.targetBlueprintBlock == null) {
            this.targetBlueprintBlock = "null";
        }
        ArrayList<Integer> originPos = new ArrayList<Integer>();
        originPos.add(this.originPosition.getX());
        originPos.add(this.originPosition.getY());
        originPos.add(this.originPosition.getZ());
        compoundTag.putIntArray("origin_blockPos", originPos);
        compoundTag.putString("target_block", this.targetBlueprintBlock);
    }

    protected void loadAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        int[] originPos = compoundTag.getIntArray("origin_blockPos");
        this.originPosition = new BlockPos(originPos[0], originPos[1], originPos[2]);
        this.targetBlueprintBlock = compoundTag.getString("target_block");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, new HolderLookup.Provider(this){

            @NotNull
            public Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
                return Stream.empty();
            }

            @NotNull
            public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(@NotNull ResourceKey<? extends Registry<? extends T>> p_256285_) {
                return Optional.empty();
            }
        });
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        this.loadAdditional(pkt.getTag(), lookupProvider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    public String getTargetBlock() {
        return this.targetBlueprintBlock;
    }

    public BlockPos getOriginBlockPos() {
        return this.originPosition;
    }

    @NotNull
    public HologramContainer create(int windowId, @NotNull Inventory inv, @NotNull RegistryFriendlyByteBuf data) {
        return new HologramContainer(windowId, inv, data);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"container.isthisindustry.hologram");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory inv, @NotNull Player plr) {
        return new HologramContainer(windowId, inv, null);
    }
}

