/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.blockEntity;

import com.folumo.isthisindustry.common.blockEntity.ElectricBE;
import com.folumo.isthisindustry.common.containers.MakeshiftDrillMachineContainer;
import com.folumo.isthisindustry.common.inerfaces.IEnergyConsumer;
import com.folumo.isthisindustry.common.reg.BlockEntityReg;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeshiftDrillMachineBlockEntity
extends ElectricBE
implements IEnergyConsumer,
MenuProvider {
    private static final int MIN_ENERGY_TO_WORK = 250;
    private int progressTime = 0;
    private int maxTime = 100;
    public static final TagKey<Item> ORES_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ores"));
    private Item toOutput = null;
    private int toGrant = 1;

    public MakeshiftDrillMachineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityReg.MAKESHIFT_DRILL_MACHINE.blockEntity.get(), pos, state, (NonNullList<ItemStack>)NonNullList.withSize((int)10, (Object)ItemStack.EMPTY), 2);
        this.initialisePower(1000, 0, true, true);
        this.dataAccess = new SimpleContainerData(2){

            public int get(int index) {
                return switch (index) {
                    case 0 -> MakeshiftDrillMachineBlockEntity.this.progressTime;
                    case 1 -> MakeshiftDrillMachineBlockEntity.this.maxTime;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        MakeshiftDrillMachineBlockEntity.this.progressTime = value;
                        break;
                    }
                    case 1: {
                        MakeshiftDrillMachineBlockEntity.this.maxTime = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public Block getBlockDrilling() {
        Item item = this.getItem(0).getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.getBlock();
        }
        return null;
    }

    @Override
    public void setItem(int index, @NotNull ItemStack itemStack) {
        super.setItem(index, itemStack);
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @Override
    @NotNull
    public ItemStack getItem(int i) {
        ItemStack item = super.getItem(i);
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
        return item;
    }

    public boolean hasAnOre() {
        return !this.getItem(0).isEmpty();
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"container.isthisindustry.makeshift_drill_machine");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory inventory, @NotNull Player player) {
        return new MakeshiftDrillMachineContainer(windowId, inventory, this, this.getContainerData());
    }

    private boolean willAbleToWork() {
        if (!this.hasAnOre()) {
            return false;
        }
        ItemStack itemStack = this.getItem(0);
        Item item = itemStack.getItem();
        if (item instanceof BlockItem) {
            boolean has = itemStack.is(ORES_TAG);
            this.toOutput = item;
            if (!this.isOutputReady()) {
                return false;
            }
            return has;
        }
        return false;
    }

    private void work() {
        if (this.getEnergyStored() >= 250) {
            this.extractEnergy(250, false);
            ++this.progressTime;
            if (this.progressTime >= this.maxTime) {
                this.progressTime = 0;
                this.onDone();
            }
        }
    }

    private boolean isOutputReady() {
        if (this.toOutput == null) {
            return false;
        }
        ItemStack output = new ItemStack((ItemLike)this.toOutput, this.toGrant);
        for (int i = 1; i < this.items.size(); ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)output) || stack.getCount() + output.getCount() > stack.getMaxStackSize()) continue;
            return true;
        }
        return false;
    }

    private void onDone() {
        ItemStack output = new ItemStack((ItemLike)this.toOutput, this.toGrant);
        for (int i = 1; i < this.items.size(); ++i) {
            int space;
            ItemStack slotStack = (ItemStack)this.items.get(i);
            if (slotStack.isEmpty()) {
                this.items.set(i, (Object)output);
                return;
            }
            if (!ItemStack.isSameItem((ItemStack)slotStack, (ItemStack)output) || (space = slotStack.getMaxStackSize() - slotStack.getCount()) <= 0) continue;
            int toMove = Math.min(space, output.getCount());
            slotStack.grow(toMove);
            output.shrink(toMove);
            if (!output.isEmpty()) continue;
            return;
        }
        if (!output.isEmpty()) {
            assert (this.level != null);
            Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)output);
        }
    }

    @Override
    public void serverTick(Level level, BlockPos blockPos, BlockState blockState) {
        super.serverTick(level, blockPos, blockState);
        boolean canWork = this.willAbleToWork();
        if (canWork) {
            this.work();
        }
    }
}

