/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.blockEntity;

import com.folumo.isthisindustry.common.blockEntity.ElectricBE;
import com.folumo.isthisindustry.common.containers.MakeshiftPressContainer;
import com.folumo.isthisindustry.common.reg.BlockEntityReg;
import com.folumo.isthisindustry.common.reg.ItemReg;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeshiftPressBlockEntity
extends ElectricBE {
    private boolean doesWork = false;
    private int progressTime = 0;
    private int maxTime = 400;

    public MakeshiftPressBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityReg.MAKESHIFT_PRESS.blockEntity.get(), pos, state, (NonNullList<ItemStack>)NonNullList.withSize((int)4, (Object)ItemStack.EMPTY), 2);
        this.dataAccess = new SimpleContainerData(2){

            public int get(int index) {
                return switch (index) {
                    case 0 -> MakeshiftPressBlockEntity.this.progressTime;
                    case 1 -> MakeshiftPressBlockEntity.this.maxTime;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        MakeshiftPressBlockEntity.this.progressTime = value;
                        break;
                    }
                    case 1: {
                        MakeshiftPressBlockEntity.this.maxTime = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public void dropAllContents(Level level, BlockPos pos) {
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
        }
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.putBoolean("doesWork", this.doesWork);
        compoundTag.putInt("progressTime", this.progressTime);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.doesWork = compoundTag.getBoolean("doesWork");
        this.progressTime = compoundTag.getInt("progressTime");
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"container.isthisindustry.makeshift_press");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory inventory, @NotNull Player player) {
        return new MakeshiftPressContainer(windowId, inventory, this, this.getContainerData());
    }

    public void setWork(boolean work) {
        this.doesWork = work;
    }

    public boolean getWork() {
        return this.doesWork;
    }

    private static ItemStack popFromStack(ItemStack itemStack) {
        int count = itemStack.getCount();
        if (count - 1 <= 0) {
            return new ItemStack((ItemLike)Items.AIR);
        }
        return new ItemStack(itemStack.getItemHolder(), count - 1);
    }

    private static boolean canMake(MakeshiftPressBlockEntity be) {
        ItemStack i1 = be.getItem(0);
        ItemStack i2 = be.getItem(1);
        ItemStack i3 = be.getItem(2);
        ItemStack i4 = be.getItem(3);
        if (i1.getItem() == ItemReg.TRANSISTOR.get() && i2.getItem() == ItemReg.SILICON.get() && i3.getItem() == ItemReg.COPPER_WIRE.get() && i1.getCount() >= 1 && i2.getCount() >= 1 && i3.getCount() >= 1 && (i4.getItem() == ItemReg.MAKESHIFT_CIRCUIT.get() || i4.getItem() == Items.AIR)) {
            return i4.getCount() < i4.getMaxStackSize();
        }
        return false;
    }

    private static void make(MakeshiftPressBlockEntity be) {
        ItemStack i1 = be.getItem(0);
        ItemStack i2 = be.getItem(1);
        ItemStack i3 = be.getItem(2);
        ItemStack i4 = be.getItem(3);
        ItemStack itemStack = new ItemStack((ItemLike)ItemReg.MAKESHIFT_CIRCUIT.get(), i4.getCount() + 1);
        be.setItem(3, itemStack);
        be.setItem(0, MakeshiftPressBlockEntity.popFromStack(i1));
        be.setItem(1, MakeshiftPressBlockEntity.popFromStack(i2));
        be.setItem(2, MakeshiftPressBlockEntity.popFromStack(i3));
    }

    private static void tryCraft(MakeshiftPressBlockEntity be, Level level, BlockPos blockPos) {
        if (be.getWork() && MakeshiftPressBlockEntity.canMake(be)) {
            ++be.progressTime;
            level.playSound(null, blockPos, SoundType.COPPER_BULB.getStepSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
            ((ServerLevel)level).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, Blocks.REDSTONE_BLOCK.defaultBlockState()), (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, 5, 0.1, 0.1, 0.1, 0.01);
            if (be.progressTime < be.maxTime) {
                return;
            }
            be.progressTime = 0;
            MakeshiftPressBlockEntity.make(be);
        }
    }

    @Override
    public void serverTick(Level level, BlockPos blockPos, BlockState blockState) {
        super.serverTick(level, blockPos, blockState);
        boolean doesWork = level.hasNeighborSignal(blockPos);
        this.setWork(doesWork);
        MakeshiftPressBlockEntity.tryCraft(this, level, blockPos);
    }
}

