/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.blockEntity;

import com.folumo.isthisindustry.common.blocks.SieveBlock;
import com.folumo.isthisindustry.common.reg.BlockEntityReg;
import com.folumo.tomatolib.common.blockentity.ExtendedBE;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class SieveBlockEntity
extends ExtendedBE {
    private boolean hasSand = false;
    private int progress = 0;
    private Block kindOfBlock = null;
    private static final int MAX_PROGRESS = 20;

    public SieveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityReg.SIEVE.blockEntity.get(), pos, state);
    }

    public boolean getHasSand() {
        return this.hasSand;
    }

    public Block getKindOfBlock() {
        return this.kindOfBlock;
    }

    public void insertSand(Block block) {
        if (!this.hasSand) {
            this.hasSand = true;
            this.progress = 0;
            this.kindOfBlock = block;
            this.setChanged();
            if (this.level != null) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public void sieve() {
        if (this.hasSand) {
            ++this.progress;
            if (this.progress >= 20) {
                this.dropOutput();
                this.hasSand = false;
                this.progress = 0;
            }
            this.setChanged();
            if (this.level != null) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    private void dropOutput() {
        if (this.level != null && !this.level.isClientSide) {
            List<ItemStack> output = SieveBlock.getOutputFor(this.kindOfBlock);
            for (ItemStack itemStack : output) {
                Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)(this.worldPosition.getY() + 1), (double)this.worldPosition.getZ(), (ItemStack)itemStack);
            }
        }
    }

    public float getProgressFraction() {
        return this.hasSand ? (float)this.progress / 20.0f : 0.0f;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, new HolderLookup.Provider(this){

            @NotNull
            public Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
                return Stream.empty();
            }

            @NotNull
            public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(@NotNull ResourceKey<? extends Registry<? extends T>> p_256285_) {
                return Optional.empty();
            }
        });
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        this.loadAdditional(pkt.getTag(), lookupProvider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.putBoolean("HasSand", this.hasSand);
        compoundTag.putInt("Progress", this.progress);
        compoundTag.putString("blockType", BuiltInRegistries.BLOCK.getKey((Object)this.kindOfBlock).toString());
    }

    protected void loadAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.hasSand = compoundTag.getBoolean("HasSand");
        this.progress = compoundTag.getInt("Progress");
        this.kindOfBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)compoundTag.getString("blockType")));
    }
}

