/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.blocks;

import com.folumo.isthisindustry.common.blockEntity.FirePlaceBlockEntity;
import com.folumo.isthisindustry.common.inerfaces.IBlueprint;
import com.folumo.isthisindustry.common.reg.BlockEntityReg;
import com.folumo.isthisindustry.common.reg.BlockReg;
import com.folumo.tomatolib.common.block.ExtendedBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class FirePlaceBlock
extends ExtendedBlock
implements EntityBlock,
IBlueprint {
    public FirePlaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new FirePlaceBlockEntity(pos, state);
    }

    public void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        BlockPos above = pos.above();
        if (level.getBlockState(above).isAir()) {
            level.setBlock(above, ((Block)BlockReg.FIRE_PLACE_TOP_BLOCK.get()).defaultBlockState(), 3);
        } else {
            level.removeBlock(pos, false);
        }
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            level.removeBlock(pos.above(), false);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockEntity tile;
        if (!level.isClientSide() && (tile = level.getBlockEntity(pos)) instanceof FirePlaceBlockEntity) {
            FirePlaceBlockEntity table = (FirePlaceBlockEntity)tile;
            player.openMenu((MenuProvider)table, pos);
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    public List<BlockPos> getBlueprintSize(BlockPos origin) {
        return List.of(origin, origin.above());
    }

    @Override
    public List<ItemStack> blueprintCost() {
        return List.of(new ItemStack((ItemLike)BlockReg.FIREBRICKS.item.get(), 2));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return FirePlaceBlock.createTicker(level, blockEntityType, (BlockEntityType<FirePlaceBlockEntity>)((BlockEntityType)BlockEntityReg.FIRE_PLACE.blockEntity.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<FirePlaceBlockEntity> blockEntityType2) {
        return level.isClientSide ? null : FirePlaceBlock.createTickerHelper(blockEntityType, blockEntityType2, FirePlaceBlockEntity::serverTick);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }
}

