/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.blocks;

import com.folumo.isthisindustry.common.BlockShapes.BlockShapes;
import com.folumo.isthisindustry.common.blockEntity.MakeshiftDrillMachineBlockEntity;
import com.folumo.isthisindustry.common.blocks.transporters.ConsumerBlock;
import com.folumo.isthisindustry.common.inerfaces.IBlueprint;
import com.folumo.isthisindustry.common.misc.TickerHelper;
import com.folumo.isthisindustry.common.reg.BlockEntityReg;
import com.folumo.isthisindustry.common.reg.BlockReg;
import com.folumo.isthisindustry.common.reg.ItemReg;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class MakeshiftDrillMachineBlock
extends ConsumerBlock
implements EntityBlock,
IBlueprint {
    public MakeshiftDrillMachineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new MakeshiftDrillMachineBlockEntity(pos, state);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        MakeshiftDrillMachineBlockEntity be;
        BlockEntity blockEntity = blockGetter.getBlockEntity(blockPos);
        if (blockEntity instanceof MakeshiftDrillMachineBlockEntity && (be = (MakeshiftDrillMachineBlockEntity)blockEntity).hasAnOre()) {
            return BlockShapes.MAKESHIFT_DRILL_MACHINE_SHAPE_ORE;
        }
        return BlockShapes.MAKESHIFT_DRILL_MACHINE_SHAPE;
    }

    @Override
    public void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        BlockPos above = pos.above();
        if (level.getBlockState(above).isAir()) {
            level.setBlock(above, ((Block)BlockReg.MAKESHIFT_DRILL_TOP_BLOCK.get()).defaultBlockState(), 3);
        } else {
            level.removeBlock(pos, false);
        }
    }

    @Override
    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        BlockPos above;
        if (!state.is(newState.getBlock()) && level.getBlockState(above = pos.above()).is((Block)BlockReg.MAKESHIFT_DRILL_TOP_BLOCK.get())) {
            level.removeBlock(above, false);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockEntity tile;
        if (!level.isClientSide() && (tile = level.getBlockEntity(pos)) instanceof MakeshiftDrillMachineBlockEntity) {
            MakeshiftDrillMachineBlockEntity table = (MakeshiftDrillMachineBlockEntity)tile;
            player.openMenu((MenuProvider)table, pos);
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    public List<BlockPos> getBlueprintSize(BlockPos origin) {
        return List.of(origin, origin.above());
    }

    @Override
    public List<ItemStack> blueprintCost() {
        return List.of(new ItemStack((ItemLike)BlockReg.MAKESHIFT_UNIVERSAL_FRAME.item.get(), 2), new ItemStack((ItemLike)ItemReg.MAKESHIFT_CIRCUIT.get(), 4), new ItemStack((ItemLike)ItemReg.ENERGY_CORE.get(), 4), new ItemStack((ItemLike)Items.IRON_INGOT, 8), new ItemStack((ItemLike)Items.REDSTONE, 16), new ItemStack((ItemLike)Items.DIAMOND_PICKAXE, 1));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return TickerHelper.createTicker(level, blockEntityType, (BlockEntityType)BlockEntityReg.MAKESHIFT_DRILL_MACHINE.blockEntity.get());
    }
}

