/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.blocks;

import com.folumo.isthisindustry.common.BlockShapes.BlockShapes;
import com.folumo.isthisindustry.common.blockEntity.MakeshiftDrillMachineBlockEntity;
import com.folumo.isthisindustry.common.reg.BlockEntityReg;
import com.folumo.tomatolib.common.block.ExtendedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class MakeshiftDrillMachineTopBlock
extends ExtendedBlock {
    public MakeshiftDrillMachineTopBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        BlockPos below;
        if (!state.is(newState.getBlock()) && level.getBlockState(below = pos.below()).is((Holder)BlockEntityReg.MAKESHIFT_DRILL_MACHINE.blockData.block)) {
            BlockEntity blockEntity = level.getBlockEntity(below);
            if (blockEntity instanceof MakeshiftDrillMachineBlockEntity) {
                MakeshiftDrillMachineBlockEntity drillBE = (MakeshiftDrillMachineBlockEntity)blockEntity;
                drillBE.dropContents();
                drillBE.setRemoved();
                level.removeBlockEntity(below);
            }
            level.removeBlock(below, false);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState p_60555_, @NotNull BlockGetter p_60556_, @NotNull BlockPos p_60557_, @NotNull CollisionContext p_60558_) {
        return BlockShapes.MAKESHIFT_DRILL_TOP_SHAPE;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockEntity tile;
        if (!level.isClientSide() && (tile = level.getBlockEntity(pos.below())) instanceof MakeshiftDrillMachineBlockEntity) {
            MakeshiftDrillMachineBlockEntity table = (MakeshiftDrillMachineBlockEntity)tile;
            player.openMenu((MenuProvider)table, pos.below());
        }
        return ItemInteractionResult.SUCCESS;
    }
}

