/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.blocks;

import com.folumo.isthisindustry.common.BlockShapes.BlockShapes;
import com.folumo.isthisindustry.common.blockEntity.MakeshiftPressBlockEntity;
import com.folumo.isthisindustry.common.misc.TickerHelper;
import com.folumo.isthisindustry.common.reg.BlockEntityReg;
import com.folumo.tomatolib.common.block.ExtendedBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class MakeshiftPressBlock
extends ExtendedBlock
implements EntityBlock {
    public MakeshiftPressBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new MakeshiftPressBlockEntity(pos, state);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        return BlockShapes.MAKESHIFT_SHAPE;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockEntity tile;
        if (!level.isClientSide() && (tile = level.getBlockEntity(pos)) instanceof MakeshiftPressBlockEntity) {
            MakeshiftPressBlockEntity table = (MakeshiftPressBlockEntity)tile;
            player.openMenu((MenuProvider)table, pos);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof MakeshiftPressBlockEntity) {
                MakeshiftPressBlockEntity press = (MakeshiftPressBlockEntity)be;
                press.dropAllContents(level, pos);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return TickerHelper.createTicker(level, blockEntityType, (BlockEntityType)BlockEntityReg.MAKESHIFT_PRESS.blockEntity.get());
    }
}

