/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.blocks;

import com.folumo.isthisindustry.common.BlockShapes.BlockShapes;
import com.folumo.isthisindustry.common.blockEntity.SieveBlockEntity;
import com.folumo.isthisindustry.common.reg.BlockReg;
import com.folumo.isthisindustry.common.reg.ItemReg;
import com.folumo.tomatolib.common.block.ExtendedBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SieveBlock
extends ExtendedBlock
implements EntityBlock {
    public SieveBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public List<Block> getAllowedBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        blocks.add(Blocks.SAND);
        blocks.add(Blocks.RED_SAND);
        blocks.add((Block)BlockReg.QUARTZ_SAND.block.get());
        blocks.add(Blocks.GRAVEL);
        blocks.add(Blocks.SUSPICIOUS_SAND);
        blocks.add(Blocks.SUSPICIOUS_GRAVEL);
        blocks.add(Blocks.SOUL_SAND);
        return blocks;
    }

    public boolean isAllowed(Block block) {
        List<Block> allowedBlocks = this.getAllowedBlocks();
        for (Block allowedBlock : allowedBlocks) {
            if (allowedBlock != block) continue;
            return true;
        }
        return false;
    }

    public static List<ItemStack> getOutputFor(Block block) {
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>();
        if (block == Blocks.SAND) {
            toReturn.add(new ItemStack(ItemReg.QUARTZ_SAND_DUST, 4));
        } else if (block == Blocks.RED_SAND) {
            toReturn.add(new ItemStack(ItemReg.QUARTZ_SAND_DUST, 2));
            toReturn.add(new ItemStack((ItemLike)Items.RAW_IRON, 1));
        } else if (block == BlockReg.QUARTZ_SAND.block.get()) {
            toReturn.add(new ItemStack(ItemReg.SILICON, 1));
        } else if (block == Blocks.GRAVEL) {
            toReturn.add(new ItemStack((ItemLike)Items.FLINT, 1));
        } else if (block == Blocks.SUSPICIOUS_SAND) {
            toReturn.add(new ItemStack((ItemLike)Items.SAND, 1));
        } else if (block == Blocks.SUSPICIOUS_GRAVEL) {
            toReturn.add(new ItemStack((ItemLike)Items.GRAVEL, 1));
        } else if (block == Blocks.SOUL_SAND) {
            Random random = new Random();
            int result = random.nextInt(100) + 1;
            if (result == 50) {
                toReturn.add(new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL, 1));
            }
        } else {
            toReturn.add(new ItemStack((ItemLike)Items.AIR));
        }
        return toReturn;
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new SieveBlockEntity(pos, state);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack itemStack, @NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        BlockEntity be = level.getBlockEntity(blockPos);
        if (be instanceof SieveBlockEntity) {
            BlockItem asBlock;
            SieveBlockEntity sieve = (SieveBlockEntity)be;
            Item item = itemStack.getItem();
            if (item instanceof BlockItem && this.isAllowed((asBlock = (BlockItem)item).getBlock()) && !sieve.getHasSand()) {
                if (!level.isClientSide) {
                    sieve.insertSand(asBlock.getBlock());
                    level.playSound(null, blockPos, SoundType.SAND.getStepSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!player.isCreative()) {
                        itemStack.shrink(1);
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (sieve.getHasSand()) {
                if (!level.isClientSide) {
                    sieve.sieve();
                    level.playSound(null, blockPos, SoundType.SAND.getStepSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    Block block = sieve.getKindOfBlock();
                    ((ServerLevel)level).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, block.defaultBlockState()), (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 1.0, (double)blockPos.getZ() + 0.5, 10, 0.2, 0.1, 0.2, 0.01);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        return BlockShapes.SIEVE_SHAPE;
    }

    public boolean onDestroyedByPlayer(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, boolean willHarvest, @NotNull FluidState fluid) {
        SieveBlockEntity sieve;
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof SieveBlockEntity && (sieve = (SieveBlockEntity)be).getHasSand()) {
            Block block = sieve.getKindOfBlock();
            ItemStack silicon = new ItemStack((ItemLike)block.asItem());
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), (ItemStack)silicon);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }
}

